/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.okhttp3;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import zipkin2.Call;
import zipkin2.CheckResult;
import zipkin2.codec.Encoding;
import zipkin2.internal.Platform;
import zipkin2.reporter.Sender;
import zipkin2.reporter.okhttp3.AutoValue_OkHttpSender;
import zipkin2.reporter.okhttp3.HttpCall;
import zipkin2.reporter.okhttp3.RequestBodyMessageEncoder;

@AutoValue
public abstract class OkHttpSender
extends Sender {
    volatile boolean closeCalled;

    public static OkHttpSender create(String endpoint) {
        return OkHttpSender.newBuilder().encoding(Encoding.JSON).endpoint(endpoint).build();
    }

    public static Builder newBuilder() {
        return new AutoValue_OkHttpSender.Builder().encoding(Encoding.JSON).compressionEnabled(true).maxRequests(64).messageMaxBytes(0x500000);
    }

    public final Builder toBuilder() {
        return new AutoValue_OkHttpSender.Builder().endpoint(this.endpoint()).maxRequests(this.client().dispatcher().getMaxRequests()).compressionEnabled(this.compressionEnabled()).encoding(this.encoding()).messageMaxBytes(this.messageMaxBytes());
    }

    abstract HttpUrl endpoint();

    abstract OkHttpClient client();

    abstract int maxRequests();

    abstract boolean compressionEnabled();

    abstract RequestBodyMessageEncoder encoder();

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return this.encoding().listSizeInBytes(encodedSpans);
    }

    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        Request request;
        if (this.closeCalled) {
            throw new IllegalStateException("closed");
        }
        try {
            request = this.newRequest(this.encoder().encode(encodedSpans));
        }
        catch (IOException e) {
            throw Platform.get().uncheckedIOException(e);
        }
        return new HttpCall(this.client().newCall(request));
    }

    public CheckResult check() {
        try {
            Request request = new Request.Builder().url(this.endpoint()).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)"[]")).build();
            try (Response response = this.client().newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new IllegalStateException("check response failed: " + response);
                }
            }
            return CheckResult.OK;
        }
        catch (Exception e) {
            return CheckResult.failed((Throwable)e);
        }
    }

    public synchronized void close() {
        if (this.closeCalled) {
            return;
        }
        this.closeCalled = true;
        Dispatcher dispatcher = this.client().dispatcher();
        dispatcher.executorService().shutdown();
        try {
            if (!dispatcher.executorService().awaitTermination(1L, TimeUnit.SECONDS)) {
                dispatcher.cancelAll();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    Request newRequest(RequestBody body) throws IOException {
        Request.Builder request = new Request.Builder().url(this.endpoint());
        if (this.compressionEnabled()) {
            request.addHeader("Content-Encoding", "gzip");
            Buffer gzipped = new Buffer();
            BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)gzipped));
            body.writeTo(gzipSink);
            gzipSink.close();
            body = new BufferRequestBody(body.contentType(), gzipped);
        }
        request.post(body);
        return request.build();
    }

    public final String toString() {
        return "OkHttpSender(" + this.endpoint() + ")";
    }

    OkHttpSender() {
    }

    static final class BufferRequestBody
    extends RequestBody {
        final MediaType contentType;
        final Buffer body;

        BufferRequestBody(MediaType contentType, Buffer body) {
            this.contentType = contentType;
            this.body = body;
        }

        public long contentLength() throws IOException {
            return this.body.size();
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            sink.write(this.body, this.body.size());
        }
    }

    public static abstract class Builder {
        public final Builder endpoint(String endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint == null");
            }
            HttpUrl parsed = HttpUrl.parse((String)endpoint);
            if (parsed == null) {
                throw new IllegalArgumentException("invalid post url: " + endpoint);
            }
            return this.endpoint(parsed);
        }

        public abstract Builder endpoint(HttpUrl var1);

        public abstract Builder compressionEnabled(boolean var1);

        public abstract Builder messageMaxBytes(int var1);

        public abstract Builder maxRequests(int var1);

        public abstract Builder encoding(Encoding var1);

        public abstract OkHttpClient.Builder clientBuilder();

        abstract int maxRequests();

        abstract Encoding encoding();

        public final OkHttpSender build() {
            ThreadPoolExecutor dispatchExecutor = new ThreadPoolExecutor(0, this.maxRequests(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory((String)"OkHttpSender Dispatcher", (boolean)false));
            Dispatcher dispatcher = new Dispatcher((ExecutorService)dispatchExecutor);
            dispatcher.setMaxRequests(this.maxRequests());
            dispatcher.setMaxRequestsPerHost(this.maxRequests());
            this.clientBuilder().dispatcher(dispatcher).build();
            if (this.encoding() == Encoding.JSON) {
                return this.encoder(RequestBodyMessageEncoder.JSON).autoBuild();
            }
            throw new UnsupportedOperationException("Unsupported encoding: " + this.encoding().name());
        }

        abstract Builder encoder(RequestBodyMessageEncoder var1);

        abstract OkHttpSender autoBuild();

        Builder() {
        }
    }
}

