/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.okhttp3;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.jvnet.animal_sniffer.IgnoreJRERequirement;

abstract class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();

    Platform() {
    }

    RuntimeException uncheckedIOException(IOException e) {
        return new RuntimeException(e);
    }

    static Platform get() {
        return PLATFORM;
    }

    static Platform findPlatform() {
        try {
            Class.forName("java.io.UncheckedIOException");
            return new Jre8();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Jre6.build();
        }
    }

    static final class Jre8
    extends Platform {
        Jre8() {
        }

        @Override
        @IgnoreJRERequirement
        public RuntimeException uncheckedIOException(IOException e) {
            return new UncheckedIOException(e);
        }
    }

    static final class Jre6
    extends Platform {
        Jre6() {
        }

        static Jre6 build() {
            return new Jre6();
        }
    }
}

