/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.urlconnection;

import com.google.auto.value.AutoValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.CheckResult;
import zipkin2.codec.Encoding;
import zipkin2.reporter.BytesMessageEncoder;
import zipkin2.reporter.Sender;
import zipkin2.reporter.internal.BaseCall;
import zipkin2.reporter.urlconnection.AutoValue_URLConnectionSender;

@AutoValue
public abstract class URLConnectionSender
extends Sender {
    volatile boolean closeCalled;

    public static URLConnectionSender create(String endpoint) {
        return URLConnectionSender.newBuilder().endpoint(endpoint).build();
    }

    public static Builder newBuilder() {
        return new AutoValue_URLConnectionSender.Builder().encoding(Encoding.JSON).connectTimeout(10000).readTimeout(60000).compressionEnabled(true).messageMaxBytes(0x500000);
    }

    public abstract Builder toBuilder();

    abstract BytesMessageEncoder encoder();

    abstract URL endpoint();

    abstract int connectTimeout();

    abstract int readTimeout();

    abstract boolean compressionEnabled();

    abstract String mediaType();

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return this.encoding().listSizeInBytes(encodedSpans);
    }

    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        if (this.closeCalled) {
            throw new IllegalStateException("close");
        }
        return new HttpPostCall(this.encoder().encode(encodedSpans));
    }

    public CheckResult check() {
        try {
            this.send(new byte[]{91, 93}, "application/json");
            return CheckResult.OK;
        }
        catch (Throwable e) {
            Call.propagateIfFatal((Throwable)e);
            return CheckResult.failed((Throwable)e);
        }
    }

    public void close() {
        this.closeCalled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(byte[] body, String mediaType) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.endpoint().openConnection();
        connection.setConnectTimeout(this.connectTimeout());
        connection.setReadTimeout(this.readTimeout());
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Content-Type", mediaType);
        if (this.compressionEnabled()) {
            connection.addRequestProperty("Content-Encoding", "gzip");
            ByteArrayOutputStream gzipped = new ByteArrayOutputStream();
            GZIPOutputStream compressor = new GZIPOutputStream(gzipped);
            try {
                compressor.write(body);
            }
            finally {
                compressor.close();
            }
            body = gzipped.toByteArray();
        }
        connection.setDoOutput(true);
        connection.setFixedLengthStreamingMode(body.length);
        connection.getOutputStream().write(body);
        URLConnectionSender.skipAllContent(connection);
    }

    static void skipAllContent(HttpURLConnection connection) throws IOException {
        InputStream in = connection.getInputStream();
        IOException thrown = URLConnectionSender.skipAndSuppress(in);
        if (thrown == null) {
            return;
        }
        InputStream err = connection.getErrorStream();
        if (err != null) {
            URLConnectionSender.skipAndSuppress(err);
        }
        throw thrown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IOException skipAndSuppress(InputStream in) {
        try {
            while (in.read() != -1) {
            }
            IOException iOException = null;
            return iOException;
        }
        catch (IOException e) {
            IOException iOException = e;
            return iOException;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public final String toString() {
        return "URLConnectionSender(" + this.endpoint() + ")";
    }

    URLConnectionSender() {
    }

    class HttpPostCall
    extends BaseCall<Void> {
        private final byte[] message;

        HttpPostCall(byte[] message) {
            this.message = message;
        }

        protected Void doExecute() throws IOException {
            URLConnectionSender.this.send(this.message, URLConnectionSender.this.mediaType());
            return null;
        }

        protected void doEnqueue(Callback<Void> callback) {
            try {
                URLConnectionSender.this.send(this.message, URLConnectionSender.this.mediaType());
                callback.onSuccess(null);
            }
            catch (IOException | Error | RuntimeException e) {
                callback.onError(e);
            }
        }

        public Call<Void> clone() {
            return new HttpPostCall(this.message);
        }
    }

    public static abstract class Builder {
        public final Builder endpoint(String endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint == null");
            }
            try {
                return this.endpoint(new URL(endpoint));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        public abstract Builder endpoint(URL var1);

        public abstract Builder connectTimeout(int var1);

        public abstract Builder readTimeout(int var1);

        public abstract Builder compressionEnabled(boolean var1);

        public abstract Builder messageMaxBytes(int var1);

        public abstract Builder encoding(Encoding var1);

        abstract Encoding encoding();

        public final URLConnectionSender build() {
            if (this.encoding() == Encoding.JSON) {
                return this.mediaType("application/json").encoder(BytesMessageEncoder.JSON).autoBuild();
            }
            throw new UnsupportedOperationException("Unsupported encoding: " + this.encoding().name());
        }

        abstract Builder encoder(BytesMessageEncoder var1);

        abstract Builder mediaType(String var1);

        abstract URLConnectionSender autoBuild();

        Builder() {
        }
    }
}

