
package zipkin2.reporter.urlconnection;

import java.net.URL;
import javax.annotation.Generated;
import zipkin2.codec.Encoding;
import zipkin2.reporter.BytesMessageEncoder;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_URLConnectionSender extends URLConnectionSender {

  private final Encoding encoding;
  private final int messageMaxBytes;
  private final BytesMessageEncoder encoder;
  private final URL endpoint;
  private final int connectTimeout;
  private final int readTimeout;
  private final boolean compressionEnabled;
  private final String mediaType;

  private AutoValue_URLConnectionSender(
      Encoding encoding,
      int messageMaxBytes,
      BytesMessageEncoder encoder,
      URL endpoint,
      int connectTimeout,
      int readTimeout,
      boolean compressionEnabled,
      String mediaType) {
    this.encoding = encoding;
    this.messageMaxBytes = messageMaxBytes;
    this.encoder = encoder;
    this.endpoint = endpoint;
    this.connectTimeout = connectTimeout;
    this.readTimeout = readTimeout;
    this.compressionEnabled = compressionEnabled;
    this.mediaType = mediaType;
  }

  @Override
  public Encoding encoding() {
    return encoding;
  }

  @Override
  public int messageMaxBytes() {
    return messageMaxBytes;
  }

  @Override
  BytesMessageEncoder encoder() {
    return encoder;
  }

  @Override
  URL endpoint() {
    return endpoint;
  }

  @Override
  int connectTimeout() {
    return connectTimeout;
  }

  @Override
  int readTimeout() {
    return readTimeout;
  }

  @Override
  boolean compressionEnabled() {
    return compressionEnabled;
  }

  @Override
  String mediaType() {
    return mediaType;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof URLConnectionSender) {
      URLConnectionSender that = (URLConnectionSender) o;
      return (this.encoding.equals(that.encoding()))
           && (this.messageMaxBytes == that.messageMaxBytes())
           && (this.encoder.equals(that.encoder()))
           && (this.endpoint.equals(that.endpoint()))
           && (this.connectTimeout == that.connectTimeout())
           && (this.readTimeout == that.readTimeout())
           && (this.compressionEnabled == that.compressionEnabled())
           && (this.mediaType.equals(that.mediaType()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.encoding.hashCode();
    h *= 1000003;
    h ^= this.messageMaxBytes;
    h *= 1000003;
    h ^= this.encoder.hashCode();
    h *= 1000003;
    h ^= this.endpoint.hashCode();
    h *= 1000003;
    h ^= this.connectTimeout;
    h *= 1000003;
    h ^= this.readTimeout;
    h *= 1000003;
    h ^= this.compressionEnabled ? 1231 : 1237;
    h *= 1000003;
    h ^= this.mediaType.hashCode();
    return h;
  }

  @Override
  public URLConnectionSender.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends URLConnectionSender.Builder {
    private Encoding encoding;
    private Integer messageMaxBytes;
    private BytesMessageEncoder encoder;
    private URL endpoint;
    private Integer connectTimeout;
    private Integer readTimeout;
    private Boolean compressionEnabled;
    private String mediaType;
    Builder() {
    }
    private Builder(URLConnectionSender source) {
      this.encoding = source.encoding();
      this.messageMaxBytes = source.messageMaxBytes();
      this.encoder = source.encoder();
      this.endpoint = source.endpoint();
      this.connectTimeout = source.connectTimeout();
      this.readTimeout = source.readTimeout();
      this.compressionEnabled = source.compressionEnabled();
      this.mediaType = source.mediaType();
    }
    @Override
    public URLConnectionSender.Builder encoding(Encoding encoding) {
      if (encoding == null) {
        throw new NullPointerException("Null encoding");
      }
      this.encoding = encoding;
      return this;
    }
    @Override
    Encoding encoding() {
      if (encoding == null) {
        throw new IllegalStateException("Property \"encoding\" has not been set");
      }
      return encoding;
    }
    @Override
    public URLConnectionSender.Builder messageMaxBytes(int messageMaxBytes) {
      this.messageMaxBytes = messageMaxBytes;
      return this;
    }
    @Override
    URLConnectionSender.Builder encoder(BytesMessageEncoder encoder) {
      if (encoder == null) {
        throw new NullPointerException("Null encoder");
      }
      this.encoder = encoder;
      return this;
    }
    @Override
    public URLConnectionSender.Builder endpoint(URL endpoint) {
      if (endpoint == null) {
        throw new NullPointerException("Null endpoint");
      }
      this.endpoint = endpoint;
      return this;
    }
    @Override
    public URLConnectionSender.Builder connectTimeout(int connectTimeout) {
      this.connectTimeout = connectTimeout;
      return this;
    }
    @Override
    public URLConnectionSender.Builder readTimeout(int readTimeout) {
      this.readTimeout = readTimeout;
      return this;
    }
    @Override
    public URLConnectionSender.Builder compressionEnabled(boolean compressionEnabled) {
      this.compressionEnabled = compressionEnabled;
      return this;
    }
    @Override
    URLConnectionSender.Builder mediaType(String mediaType) {
      if (mediaType == null) {
        throw new NullPointerException("Null mediaType");
      }
      this.mediaType = mediaType;
      return this;
    }
    @Override
    URLConnectionSender autoBuild() {
      String missing = "";
      if (this.encoding == null) {
        missing += " encoding";
      }
      if (this.messageMaxBytes == null) {
        missing += " messageMaxBytes";
      }
      if (this.encoder == null) {
        missing += " encoder";
      }
      if (this.endpoint == null) {
        missing += " endpoint";
      }
      if (this.connectTimeout == null) {
        missing += " connectTimeout";
      }
      if (this.readTimeout == null) {
        missing += " readTimeout";
      }
      if (this.compressionEnabled == null) {
        missing += " compressionEnabled";
      }
      if (this.mediaType == null) {
        missing += " mediaType";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_URLConnectionSender(
          this.encoding,
          this.messageMaxBytes,
          this.encoder,
          this.endpoint,
          this.connectTimeout,
          this.readTimeout,
          this.compressionEnabled,
          this.mediaType);
    }
  }

}
