/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.urlconnection;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import zipkin2.reporter.BytesMessageEncoder;
import zipkin2.reporter.Call;
import zipkin2.reporter.Callback;
import zipkin2.reporter.CheckResult;
import zipkin2.reporter.ClosedSenderException;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.Sender;

public final class URLConnectionSender
extends Sender {
    final URL endpoint;
    final Encoding encoding;
    final String mediaType;
    final BytesMessageEncoder encoder;
    final int messageMaxBytes;
    final int connectTimeout;
    final int readTimeout;
    final boolean compressionEnabled;
    volatile boolean closeCalled;

    public static URLConnectionSender create(String endpoint) {
        return URLConnectionSender.newBuilder().endpoint(endpoint).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    URLConnectionSender(Builder builder) {
        if (builder.endpoint == null) {
            throw new NullPointerException("endpoint == null");
        }
        this.endpoint = builder.endpoint;
        this.encoding = builder.encoding;
        switch (builder.encoding) {
            case JSON: {
                this.mediaType = "application/json";
                this.encoder = BytesMessageEncoder.JSON;
                break;
            }
            case THRIFT: {
                this.mediaType = "application/x-thrift";
                this.encoder = BytesMessageEncoder.THRIFT;
                break;
            }
            case PROTO3: {
                this.mediaType = "application/x-protobuf";
                this.encoder = BytesMessageEncoder.PROTO3;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported encoding: " + this.encoding.name());
            }
        }
        this.messageMaxBytes = builder.messageMaxBytes;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.compressionEnabled = builder.compressionEnabled;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return this.encoding().listSizeInBytes(encodedSpans);
    }

    public int messageSizeInBytes(int encodedSizeInBytes) {
        return this.encoding().listSizeInBytes(encodedSizeInBytes);
    }

    public Encoding encoding() {
        return this.encoding;
    }

    public int messageMaxBytes() {
        return this.messageMaxBytes;
    }

    @Deprecated
    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        if (this.closeCalled) {
            throw new ClosedSenderException();
        }
        return new HttpPostCall(this.encoder.encode(encodedSpans));
    }

    public void send(List<byte[]> encodedSpans) throws IOException {
        if (this.closeCalled) {
            throw new ClosedSenderException();
        }
        this.send(this.encoder.encode(encodedSpans), this.mediaType);
    }

    @Deprecated
    public CheckResult check() {
        try {
            this.send(new byte[]{91, 93}, "application/json");
            return CheckResult.OK;
        }
        catch (Throwable e) {
            Call.propagateIfFatal((Throwable)e);
            return CheckResult.failed((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(byte[] body, String mediaType) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.endpoint.openConnection();
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        connection.setRequestMethod("POST");
        connection.addRequestProperty("b3", "0");
        connection.addRequestProperty("Content-Type", mediaType);
        if (this.compressionEnabled) {
            connection.addRequestProperty("Content-Encoding", "gzip");
            ByteArrayOutputStream gzipped = new ByteArrayOutputStream();
            GZIPOutputStream compressor = new GZIPOutputStream(gzipped);
            try {
                compressor.write(body);
            }
            finally {
                compressor.close();
            }
            body = gzipped.toByteArray();
        }
        connection.setDoOutput(true);
        connection.setFixedLengthStreamingMode(body.length);
        connection.getOutputStream().write(body);
        URLConnectionSender.skipAllContent(connection);
    }

    static void skipAllContent(HttpURLConnection connection) throws IOException {
        InputStream in = connection.getInputStream();
        IOException thrown = URLConnectionSender.skipAndSuppress(in);
        if (thrown == null) {
            return;
        }
        InputStream err = connection.getErrorStream();
        if (err != null) {
            URLConnectionSender.skipAndSuppress(err);
        }
        throw thrown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IOException skipAndSuppress(InputStream in) {
        try {
            while (in.read() != -1) {
            }
            IOException iOException = null;
            return iOException;
        }
        catch (IOException e) {
            IOException iOException = e;
            return iOException;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void close() {
        this.closeCalled = true;
    }

    public String toString() {
        return "URLConnectionSender{" + this.endpoint + "}";
    }

    class HttpPostCall
    extends Call.Base<Void> {
        private final byte[] message;

        HttpPostCall(byte[] message) {
            this.message = message;
        }

        protected Void doExecute() throws IOException {
            URLConnectionSender.this.send(this.message, URLConnectionSender.this.mediaType);
            return null;
        }

        protected void doEnqueue(Callback<Void> callback) {
            try {
                URLConnectionSender.this.send(this.message, URLConnectionSender.this.mediaType);
                callback.onSuccess(null);
            }
            catch (Throwable t) {
                Call.propagateIfFatal((Throwable)t);
                callback.onError(t);
            }
        }

        public Call<Void> clone() {
            return new HttpPostCall(this.message);
        }
    }

    public static final class Builder {
        URL endpoint;
        Encoding encoding = Encoding.JSON;
        int messageMaxBytes = 500000;
        int connectTimeout = 10000;
        int readTimeout = 60000;
        boolean compressionEnabled = true;

        Builder(URLConnectionSender sender) {
            this.endpoint = sender.endpoint;
            this.encoding = sender.encoding;
            this.messageMaxBytes = sender.messageMaxBytes;
            this.connectTimeout = sender.connectTimeout;
            this.readTimeout = sender.readTimeout;
            this.compressionEnabled = sender.compressionEnabled;
        }

        public Builder endpoint(String endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint == null");
            }
            try {
                return this.endpoint(new URL(endpoint));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        public Builder endpoint(URL endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint == null");
            }
            this.endpoint = endpoint;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder compressionEnabled(boolean compressionEnabled) {
            this.compressionEnabled = compressionEnabled;
            return this;
        }

        public Builder messageMaxBytes(int messageMaxBytes) {
            this.messageMaxBytes = messageMaxBytes;
            return this;
        }

        public Builder encoding(Encoding encoding) {
            if (encoding == null) {
                throw new NullPointerException("encoding == null");
            }
            this.encoding = encoding;
            return this;
        }

        public URLConnectionSender build() {
            return new URLConnectionSender(this);
        }

        Builder() {
        }
    }
}

