// Code generated by Wire protocol buffer compiler, do not edit.
// Source file: zipkin.proto
package zipkin2.proto3;

import com.squareup.wire.EnumAdapter;
import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.WireEnum;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Map;
import okio.ByteString;

/**
 * A span is a single-host view of an operation. A trace is a series of spans
 * (often RPC calls) which nest to form a latency tree. Spans are in the same
 * trace when they share the same trace ID. The parent_id field establishes the
 * position of one span in the tree.
 *
 * The root span is where parent_id is Absent and usually has the longest
 * duration in the trace. However, nested asynchronous work can materialize as
 * child spans whose duration exceed the root span.
 *
 * Spans usually represent remote activity such as RPC calls, or messaging
 * producers and consumers. However, they can also represent in-process
 * activity in any position of the trace. For example, a root span could
 * represent a server receiving an initial client request. A root span could
 * also represent a scheduled job that has no remote context.
 *
 * Encoding notes:
 *
 * Epoch timestamp are encoded fixed64 as varint would also be 8 bytes, and more
 * expensive to encode and size. Duration is stored uint64, as often the numbers
 * are quite small.
 *
 * Default values are ok, as only natural numbers are used. For example, zero is
 * an invalid timestamp and an invalid duration, false values for debug or shared
 * are ignorable, and zero-length strings also coerce to null.
 *
 * The next id is 14.
 *
 * Note fields up to 15 take 1 byte to encode. Take care when adding new fields
 * https://developers.google.com/protocol-buffers/docs/proto3#assigning-tags
 */
public final class Span extends Message<Span, Span.Builder> {
  public static final ProtoAdapter<Span> ADAPTER = new ProtoAdapter_Span();

  private static final long serialVersionUID = 0L;

  public static final ByteString DEFAULT_TRACE_ID = ByteString.EMPTY;

  public static final ByteString DEFAULT_PARENT_ID = ByteString.EMPTY;

  public static final ByteString DEFAULT_ID = ByteString.EMPTY;

  public static final Kind DEFAULT_KIND = Kind.SPAN_KIND_UNSPECIFIED;

  public static final String DEFAULT_NAME = "";

  public static final Long DEFAULT_TIMESTAMP = 0L;

  public static final Long DEFAULT_DURATION = 0L;

  public static final Boolean DEFAULT_DEBUG = false;

  public static final Boolean DEFAULT_SHARED = false;

  /**
   * Randomly generated, unique identifier for a trace, set on all spans within
   * it.
   *
   * This field is required and encoded as 8 or 16 bytes, in big endian byte
   * order.
   */
  @WireField(
      tag = 1,
      adapter = "com.squareup.wire.ProtoAdapter#BYTES"
  )
  public final ByteString trace_id;

  /**
   * The parent span ID or absent if this the root span in a trace.
   */
  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#BYTES"
  )
  public final ByteString parent_id;

  /**
   * Unique identifier for this operation within the trace.
   *
   * This field is required and encoded as 8 opaque bytes.
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#BYTES"
  )
  public final ByteString id;

  /**
   * When present, used to interpret remote_endpoint
   */
  @WireField(
      tag = 4,
      adapter = "zipkin2.proto3.Span$Kind#ADAPTER"
  )
  public final Kind kind;

  /**
   * The logical operation this span represents in lowercase (e.g. rpc method).
   * Leave absent if unknown.
   *
   * As these are lookup labels, take care to ensure names are low cardinality.
   * For example, do not embed variables into the name.
   */
  @WireField(
      tag = 5,
      adapter = "com.squareup.wire.ProtoAdapter#STRING"
  )
  public final String name;

  /**
   * Epoch microseconds of the start of this span, possibly absent if
   * incomplete.
   *
   * For example, 1502787600000000 corresponds to 2017-08-15 09:00 UTC
   *
   * This value should be set directly by instrumentation, using the most
   * precise value possible. For example, gettimeofday or multiplying epoch
   * millis by 1000.
   *
   * There are three known edge-cases where this could be reported absent.
   * - A span was allocated but never started (ex not yet received a timestamp)
   * - The span's start event was lost
   * - Data about a completed span (ex tags) were sent after the fact
   */
  @WireField(
      tag = 6,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64"
  )
  public final Long timestamp;

  /**
   * Duration in microseconds of the critical path, if known. Durations of less
   * than one are rounded up. Duration of children can be longer than their
   * parents due to asynchronous operations.
   *
   * For example 150 milliseconds is 150000 microseconds.
   */
  @WireField(
      tag = 7,
      adapter = "com.squareup.wire.ProtoAdapter#UINT64"
  )
  public final Long duration;

  /**
   * The host that recorded this span, primarily for query by service name.
   *
   * Instrumentation should always record this. Usually, absent implies late
   * data. The IP address corresponding to this is usually the site local or
   * advertised service address. When present, the port indicates the listen
   * port.
   */
  @WireField(
      tag = 8,
      adapter = "zipkin2.proto3.Endpoint#ADAPTER"
  )
  public final Endpoint local_endpoint;

  /**
   * When an RPC (or messaging) span, indicates the other side of the
   * connection.
   *
   * By recording the remote endpoint, your trace will contain network context
   * even if the peer is not tracing. For example, you can record the IP from
   * the "X-Forwarded-For" header or the service name and socket of a remote
   * peer.
   */
  @WireField(
      tag = 9,
      adapter = "zipkin2.proto3.Endpoint#ADAPTER"
  )
  public final Endpoint remote_endpoint;

  /**
   * Associates events that explain latency with the time they happened.
   */
  @WireField(
      tag = 10,
      adapter = "zipkin2.proto3.Annotation#ADAPTER",
      label = WireField.Label.REPEATED
  )
  public final List<Annotation> annotations;

  /**
   * Tags give your span context for search, viewing and analysis.
   *
   * For example, a key "your_app.version" would let you lookup traces by
   * version. A tag "sql.query" isn't searchable, but it can help in debugging
   * when viewing a trace.
   */
  @WireField(
      tag = 11,
      keyAdapter = "com.squareup.wire.ProtoAdapter#STRING",
      adapter = "com.squareup.wire.ProtoAdapter#STRING"
  )
  public final Map<String, String> tags;

  /**
   * True is a request to store this span even if it overrides sampling policy.
   *
   * This is true when the "X-B3-Flags" header has a value of 1.
   */
  @WireField(
      tag = 12,
      adapter = "com.squareup.wire.ProtoAdapter#BOOL"
  )
  public final Boolean debug;

  /**
   * True if we are contributing to a span started by another tracer (ex on a
   * different host).
   */
  @WireField(
      tag = 13,
      adapter = "com.squareup.wire.ProtoAdapter#BOOL"
  )
  public final Boolean shared;

  public Span(ByteString trace_id, ByteString parent_id, ByteString id, Kind kind, String name,
      Long timestamp, Long duration, Endpoint local_endpoint, Endpoint remote_endpoint,
      List<Annotation> annotations, Map<String, String> tags, Boolean debug, Boolean shared) {
    this(trace_id, parent_id, id, kind, name, timestamp, duration, local_endpoint, remote_endpoint, annotations, tags, debug, shared, ByteString.EMPTY);
  }

  public Span(ByteString trace_id, ByteString parent_id, ByteString id, Kind kind, String name,
      Long timestamp, Long duration, Endpoint local_endpoint, Endpoint remote_endpoint,
      List<Annotation> annotations, Map<String, String> tags, Boolean debug, Boolean shared,
      ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.trace_id = trace_id;
    this.parent_id = parent_id;
    this.id = id;
    this.kind = kind;
    this.name = name;
    this.timestamp = timestamp;
    this.duration = duration;
    this.local_endpoint = local_endpoint;
    this.remote_endpoint = remote_endpoint;
    this.annotations = Internal.immutableCopyOf("annotations", annotations);
    this.tags = Internal.immutableCopyOf("tags", tags);
    this.debug = debug;
    this.shared = shared;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.trace_id = trace_id;
    builder.parent_id = parent_id;
    builder.id = id;
    builder.kind = kind;
    builder.name = name;
    builder.timestamp = timestamp;
    builder.duration = duration;
    builder.local_endpoint = local_endpoint;
    builder.remote_endpoint = remote_endpoint;
    builder.annotations = Internal.copyOf("annotations", annotations);
    builder.tags = Internal.copyOf("tags", tags);
    builder.debug = debug;
    builder.shared = shared;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof Span)) return false;
    Span o = (Span) other;
    return unknownFields().equals(o.unknownFields())
        && Internal.equals(trace_id, o.trace_id)
        && Internal.equals(parent_id, o.parent_id)
        && Internal.equals(id, o.id)
        && Internal.equals(kind, o.kind)
        && Internal.equals(name, o.name)
        && Internal.equals(timestamp, o.timestamp)
        && Internal.equals(duration, o.duration)
        && Internal.equals(local_endpoint, o.local_endpoint)
        && Internal.equals(remote_endpoint, o.remote_endpoint)
        && annotations.equals(o.annotations)
        && tags.equals(o.tags)
        && Internal.equals(debug, o.debug)
        && Internal.equals(shared, o.shared);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + (trace_id != null ? trace_id.hashCode() : 0);
      result = result * 37 + (parent_id != null ? parent_id.hashCode() : 0);
      result = result * 37 + (id != null ? id.hashCode() : 0);
      result = result * 37 + (kind != null ? kind.hashCode() : 0);
      result = result * 37 + (name != null ? name.hashCode() : 0);
      result = result * 37 + (timestamp != null ? timestamp.hashCode() : 0);
      result = result * 37 + (duration != null ? duration.hashCode() : 0);
      result = result * 37 + (local_endpoint != null ? local_endpoint.hashCode() : 0);
      result = result * 37 + (remote_endpoint != null ? remote_endpoint.hashCode() : 0);
      result = result * 37 + annotations.hashCode();
      result = result * 37 + tags.hashCode();
      result = result * 37 + (debug != null ? debug.hashCode() : 0);
      result = result * 37 + (shared != null ? shared.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (trace_id != null) builder.append(", trace_id=").append(trace_id);
    if (parent_id != null) builder.append(", parent_id=").append(parent_id);
    if (id != null) builder.append(", id=").append(id);
    if (kind != null) builder.append(", kind=").append(kind);
    if (name != null) builder.append(", name=").append(name);
    if (timestamp != null) builder.append(", timestamp=").append(timestamp);
    if (duration != null) builder.append(", duration=").append(duration);
    if (local_endpoint != null) builder.append(", local_endpoint=").append(local_endpoint);
    if (remote_endpoint != null) builder.append(", remote_endpoint=").append(remote_endpoint);
    if (!annotations.isEmpty()) builder.append(", annotations=").append(annotations);
    if (!tags.isEmpty()) builder.append(", tags=").append(tags);
    if (debug != null) builder.append(", debug=").append(debug);
    if (shared != null) builder.append(", shared=").append(shared);
    return builder.replace(0, 2, "Span{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<Span, Builder> {
    public ByteString trace_id;

    public ByteString parent_id;

    public ByteString id;

    public Kind kind;

    public String name;

    public Long timestamp;

    public Long duration;

    public Endpoint local_endpoint;

    public Endpoint remote_endpoint;

    public List<Annotation> annotations;

    public Map<String, String> tags;

    public Boolean debug;

    public Boolean shared;

    public Builder() {
      annotations = Internal.newMutableList();
      tags = Internal.newMutableMap();
    }

    /**
     * Randomly generated, unique identifier for a trace, set on all spans within
     * it.
     *
     * This field is required and encoded as 8 or 16 bytes, in big endian byte
     * order.
     */
    public Builder trace_id(ByteString trace_id) {
      this.trace_id = trace_id;
      return this;
    }

    /**
     * The parent span ID or absent if this the root span in a trace.
     */
    public Builder parent_id(ByteString parent_id) {
      this.parent_id = parent_id;
      return this;
    }

    /**
     * Unique identifier for this operation within the trace.
     *
     * This field is required and encoded as 8 opaque bytes.
     */
    public Builder id(ByteString id) {
      this.id = id;
      return this;
    }

    /**
     * When present, used to interpret remote_endpoint
     */
    public Builder kind(Kind kind) {
      this.kind = kind;
      return this;
    }

    /**
     * The logical operation this span represents in lowercase (e.g. rpc method).
     * Leave absent if unknown.
     *
     * As these are lookup labels, take care to ensure names are low cardinality.
     * For example, do not embed variables into the name.
     */
    public Builder name(String name) {
      this.name = name;
      return this;
    }

    /**
     * Epoch microseconds of the start of this span, possibly absent if
     * incomplete.
     *
     * For example, 1502787600000000 corresponds to 2017-08-15 09:00 UTC
     *
     * This value should be set directly by instrumentation, using the most
     * precise value possible. For example, gettimeofday or multiplying epoch
     * millis by 1000.
     *
     * There are three known edge-cases where this could be reported absent.
     * - A span was allocated but never started (ex not yet received a timestamp)
     * - The span's start event was lost
     * - Data about a completed span (ex tags) were sent after the fact
     */
    public Builder timestamp(Long timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    /**
     * Duration in microseconds of the critical path, if known. Durations of less
     * than one are rounded up. Duration of children can be longer than their
     * parents due to asynchronous operations.
     *
     * For example 150 milliseconds is 150000 microseconds.
     */
    public Builder duration(Long duration) {
      this.duration = duration;
      return this;
    }

    /**
     * The host that recorded this span, primarily for query by service name.
     *
     * Instrumentation should always record this. Usually, absent implies late
     * data. The IP address corresponding to this is usually the site local or
     * advertised service address. When present, the port indicates the listen
     * port.
     */
    public Builder local_endpoint(Endpoint local_endpoint) {
      this.local_endpoint = local_endpoint;
      return this;
    }

    /**
     * When an RPC (or messaging) span, indicates the other side of the
     * connection.
     *
     * By recording the remote endpoint, your trace will contain network context
     * even if the peer is not tracing. For example, you can record the IP from
     * the "X-Forwarded-For" header or the service name and socket of a remote
     * peer.
     */
    public Builder remote_endpoint(Endpoint remote_endpoint) {
      this.remote_endpoint = remote_endpoint;
      return this;
    }

    /**
     * Associates events that explain latency with the time they happened.
     */
    public Builder annotations(List<Annotation> annotations) {
      Internal.checkElementsNotNull(annotations);
      this.annotations = annotations;
      return this;
    }

    /**
     * Tags give your span context for search, viewing and analysis.
     *
     * For example, a key "your_app.version" would let you lookup traces by
     * version. A tag "sql.query" isn't searchable, but it can help in debugging
     * when viewing a trace.
     */
    public Builder tags(Map<String, String> tags) {
      Internal.checkElementsNotNull(tags);
      this.tags = tags;
      return this;
    }

    /**
     * True is a request to store this span even if it overrides sampling policy.
     *
     * This is true when the "X-B3-Flags" header has a value of 1.
     */
    public Builder debug(Boolean debug) {
      this.debug = debug;
      return this;
    }

    /**
     * True if we are contributing to a span started by another tracer (ex on a
     * different host).
     */
    public Builder shared(Boolean shared) {
      this.shared = shared;
      return this;
    }

    @Override
    public Span build() {
      return new Span(trace_id, parent_id, id, kind, name, timestamp, duration, local_endpoint, remote_endpoint, annotations, tags, debug, shared, super.buildUnknownFields());
    }
  }

  /**
   * When present, kind clarifies timestamp, duration and remote_endpoint. When
   * absent, the span is local or incomplete. Unlike client and server, there
   * is no direct critical path latency relationship between producer and
   * consumer spans.
   */
  public enum Kind implements WireEnum {
    /**
     * Default value interpreted as absent.
     */
    SPAN_KIND_UNSPECIFIED(0),

    /**
     * The span represents the client side of an RPC operation, implying the
     * following:
     *
     * timestamp is the moment a request was sent to the server.
     * duration is the delay until a response or an error was received.
     * remote_endpoint is the server.
     */
    CLIENT(1),

    /**
     * The span represents the server side of an RPC operation, implying the
     * following:
     *
     * timestamp is the moment a client request was received.
     * duration is the delay until a response was sent or an error.
     * remote_endpoint is the client.
     */
    SERVER(2),

    /**
     * The span represents production of a message to a remote broker, implying
     * the following:
     *
     * timestamp is the moment a message was sent to a destination.
     * duration is the delay sending the message, such as batching.
     * remote_endpoint is the broker.
     */
    PRODUCER(3),

    /**
     * The span represents consumption of a message from a remote broker, not
     * time spent servicing it. For example, a message processor would be an
     * in-process child span of a consumer. Consumer spans imply the following:
     *
     * timestamp is the moment a message was received from an origin.
     * duration is the delay consuming the message, such as from backlog.
     * remote_endpoint is the broker.
     */
    CONSUMER(4);

    public static final ProtoAdapter<Kind> ADAPTER = new ProtoAdapter_Kind();

    private final int value;

    Kind(int value) {
      this.value = value;
    }

    /**
     * Return the constant for {@code value} or null.
     */
    public static Kind fromValue(int value) {
      switch (value) {
        case 0: return SPAN_KIND_UNSPECIFIED;
        case 1: return CLIENT;
        case 2: return SERVER;
        case 3: return PRODUCER;
        case 4: return CONSUMER;
        default: return null;
      }
    }

    @Override
    public int getValue() {
      return value;
    }

    private static final class ProtoAdapter_Kind extends EnumAdapter<Kind> {
      ProtoAdapter_Kind() {
        super(Kind.class);
      }

      @Override
      protected Kind fromValue(int value) {
        return Kind.fromValue(value);
      }
    }
  }

  private static final class ProtoAdapter_Span extends ProtoAdapter<Span> {
    private final ProtoAdapter<Map<String, String>> tags = ProtoAdapter.newMapAdapter(ProtoAdapter.STRING, ProtoAdapter.STRING);

    public ProtoAdapter_Span() {
      super(FieldEncoding.LENGTH_DELIMITED, Span.class);
    }

    @Override
    public int encodedSize(Span value) {
      return ProtoAdapter.BYTES.encodedSizeWithTag(1, value.trace_id)
          + ProtoAdapter.BYTES.encodedSizeWithTag(2, value.parent_id)
          + ProtoAdapter.BYTES.encodedSizeWithTag(3, value.id)
          + Kind.ADAPTER.encodedSizeWithTag(4, value.kind)
          + ProtoAdapter.STRING.encodedSizeWithTag(5, value.name)
          + ProtoAdapter.FIXED64.encodedSizeWithTag(6, value.timestamp)
          + ProtoAdapter.UINT64.encodedSizeWithTag(7, value.duration)
          + Endpoint.ADAPTER.encodedSizeWithTag(8, value.local_endpoint)
          + Endpoint.ADAPTER.encodedSizeWithTag(9, value.remote_endpoint)
          + Annotation.ADAPTER.asRepeated().encodedSizeWithTag(10, value.annotations)
          + tags.encodedSizeWithTag(11, value.tags)
          + ProtoAdapter.BOOL.encodedSizeWithTag(12, value.debug)
          + ProtoAdapter.BOOL.encodedSizeWithTag(13, value.shared)
          + value.unknownFields().size();
    }

    @Override
    public void encode(ProtoWriter writer, Span value) throws IOException {
      ProtoAdapter.BYTES.encodeWithTag(writer, 1, value.trace_id);
      ProtoAdapter.BYTES.encodeWithTag(writer, 2, value.parent_id);
      ProtoAdapter.BYTES.encodeWithTag(writer, 3, value.id);
      Kind.ADAPTER.encodeWithTag(writer, 4, value.kind);
      ProtoAdapter.STRING.encodeWithTag(writer, 5, value.name);
      ProtoAdapter.FIXED64.encodeWithTag(writer, 6, value.timestamp);
      ProtoAdapter.UINT64.encodeWithTag(writer, 7, value.duration);
      Endpoint.ADAPTER.encodeWithTag(writer, 8, value.local_endpoint);
      Endpoint.ADAPTER.encodeWithTag(writer, 9, value.remote_endpoint);
      Annotation.ADAPTER.asRepeated().encodeWithTag(writer, 10, value.annotations);
      tags.encodeWithTag(writer, 11, value.tags);
      ProtoAdapter.BOOL.encodeWithTag(writer, 12, value.debug);
      ProtoAdapter.BOOL.encodeWithTag(writer, 13, value.shared);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public Span decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.trace_id(ProtoAdapter.BYTES.decode(reader)); break;
          case 2: builder.parent_id(ProtoAdapter.BYTES.decode(reader)); break;
          case 3: builder.id(ProtoAdapter.BYTES.decode(reader)); break;
          case 4: {
            try {
              builder.kind(Kind.ADAPTER.decode(reader));
            } catch (ProtoAdapter.EnumConstantNotFoundException e) {
              builder.addUnknownField(tag, FieldEncoding.VARINT, (long) e.value);
            }
            break;
          }
          case 5: builder.name(ProtoAdapter.STRING.decode(reader)); break;
          case 6: builder.timestamp(ProtoAdapter.FIXED64.decode(reader)); break;
          case 7: builder.duration(ProtoAdapter.UINT64.decode(reader)); break;
          case 8: builder.local_endpoint(Endpoint.ADAPTER.decode(reader)); break;
          case 9: builder.remote_endpoint(Endpoint.ADAPTER.decode(reader)); break;
          case 10: builder.annotations.add(Annotation.ADAPTER.decode(reader)); break;
          case 11: builder.tags.putAll(tags.decode(reader)); break;
          case 12: builder.debug(ProtoAdapter.BOOL.decode(reader)); break;
          case 13: builder.shared(ProtoAdapter.BOOL.decode(reader)); break;
          default: {
            FieldEncoding fieldEncoding = reader.peekFieldEncoding();
            Object value = fieldEncoding.rawProtoAdapter().decode(reader);
            builder.addUnknownField(tag, fieldEncoding, value);
          }
        }
      }
      reader.endMessage(token);
      return builder.build();
    }

    @Override
    public Span redact(Span value) {
      Builder builder = value.newBuilder();
      if (builder.local_endpoint != null) builder.local_endpoint = Endpoint.ADAPTER.redact(builder.local_endpoint);
      if (builder.remote_endpoint != null) builder.remote_endpoint = Endpoint.ADAPTER.redact(builder.remote_endpoint);
      Internal.redactElements(builder.annotations, Annotation.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
