/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.elasticsearch;

import com.squareup.moshi.JsonReader;
import java.io.IOException;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import zipkin2.elasticsearch.internal.JsonReaders;
import zipkin2.server.internal.elasticsearch.ZipkinElasticsearchStorageProperties;

final class BasicAuthInterceptor
implements Interceptor {
    private String basicCredentials;

    BasicAuthInterceptor(ZipkinElasticsearchStorageProperties es) {
        this.basicCredentials = Credentials.basic((String)es.getUsername(), (String)es.getPassword());
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request input = chain.request();
        Request requestWithCredentials = this.appendBasicAuthHeaderParameters(input);
        Response response = chain.proceed(requestWithCredentials);
        if (response.code() == 403) {
            try (ResponseBody body = response.body();){
                JsonReader message = JsonReaders.enterPath((JsonReader)JsonReader.of((BufferedSource)body.source()), (String)"message");
                if (message != null) {
                    throw new IllegalStateException(message.nextString());
                }
            }
            throw new IllegalStateException(response.toString());
        }
        return response;
    }

    private Request appendBasicAuthHeaderParameters(Request input) {
        Request.Builder builder = input.newBuilder();
        return builder.header("authorization", this.basicCredentials).build();
    }
}

