/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.throttle;

import com.netflix.concurrency.limits.Limiter;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import zipkin2.Call;
import zipkin2.Callback;

final class ThrottledCall<V>
extends Call.Base<V> {
    final ExecutorService executor;
    final Limiter<Void> limiter;
    final Call<V> delegate;

    ThrottledCall(ExecutorService executor, Limiter<Void> limiter, Call<V> delegate) {
        this.executor = executor;
        this.limiter = limiter;
        this.delegate = delegate;
    }

    protected V doExecute() throws IOException {
        Limiter.Listener limitListener = (Limiter.Listener)this.limiter.acquire(null).orElseThrow(RejectedExecutionException::new);
        try {
            Future<Object> future = this.executor.submit(() -> {
                String oldName = ThrottledCall.setCurrentThreadName(this.delegate.toString());
                try {
                    Object object = this.delegate.execute();
                    return object;
                }
                finally {
                    ThrottledCall.setCurrentThreadName(oldName);
                }
            });
            Object result = future.get();
            limitListener.onSuccess();
            return (V)result;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RejectedExecutionException) {
                limitListener.onDropped();
            } else {
                limitListener.onIgnore();
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new RuntimeException("Issue while executing on a throttled call", cause);
        }
        catch (InterruptedException e) {
            limitListener.onIgnore();
            throw new RuntimeException("Interrupted while blocking on a throttled call", e);
        }
        catch (Error | RuntimeException e) {
            ThrottledCall.propagateIfFatal((Throwable)e);
            limitListener.onIgnore();
            throw e;
        }
    }

    protected void doEnqueue(Callback<V> callback) {
        Limiter.Listener limitListener = (Limiter.Listener)this.limiter.acquire(null).orElseThrow(RejectedExecutionException::new);
        try {
            this.executor.execute(new QueuedCall<V>(this.delegate, callback, limitListener));
        }
        catch (Error | RuntimeException e) {
            ThrottledCall.propagateIfFatal((Throwable)e);
            limitListener.onIgnore();
            throw e;
        }
    }

    public Call<V> clone() {
        return new ThrottledCall<V>(this.executor, this.limiter, this.delegate.clone());
    }

    public String toString() {
        return "Throttled(" + this.delegate + ")";
    }

    static String setCurrentThreadName(String name) {
        Thread thread = Thread.currentThread();
        String originalName = thread.getName();
        thread.setName(name);
        return originalName;
    }

    static final class ThrottledCallback<V>
    implements Callback<V> {
        final Callback<V> delegate;
        final Limiter.Listener limitListener;
        final CountDownLatch latch = new CountDownLatch(1);

        ThrottledCallback(Callback<V> delegate, Limiter.Listener limitListener) {
            this.delegate = delegate;
            this.limitListener = limitListener;
        }

        void await() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.limitListener.onIgnore();
                throw new RuntimeException("Interrupted while blocking on a throttled call", e);
            }
        }

        public void onSuccess(V value) {
            try {
                this.limitListener.onSuccess();
                this.delegate.onSuccess(value);
            }
            finally {
                this.latch.countDown();
            }
        }

        public void onError(Throwable t) {
            try {
                if (t instanceof RejectedExecutionException) {
                    this.limitListener.onDropped();
                } else {
                    this.limitListener.onIgnore();
                }
                this.delegate.onError(t);
            }
            finally {
                this.latch.countDown();
            }
        }

        public String toString() {
            return "Throttled(" + this.delegate + ")";
        }
    }

    static final class QueuedCall<V>
    implements Runnable {
        final Call<V> delegate;
        final Callback<V> callback;
        final Limiter.Listener limitListener;

        QueuedCall(Call<V> delegate, Callback<V> callback, Limiter.Listener limitListener) {
            this.delegate = delegate;
            this.callback = callback;
            this.limitListener = limitListener;
        }

        @Override
        public void run() {
            try {
                if (this.delegate.isCanceled()) {
                    return;
                }
                String oldName = ThrottledCall.setCurrentThreadName(this.delegate.toString());
                try {
                    this.enqueueAndWait();
                }
                finally {
                    ThrottledCall.setCurrentThreadName(oldName);
                }
            }
            catch (Error | RuntimeException e) {
                Call.propagateIfFatal((Throwable)e);
                this.limitListener.onIgnore();
                this.callback.onError(e);
            }
        }

        void enqueueAndWait() {
            ThrottledCallback<V> throttleCallback = new ThrottledCallback<V>(this.callback, this.limitListener);
            this.delegate.enqueue(throttleCallback);
            throttleCallback.await();
        }

        public String toString() {
            return "QueuedCall{delegate=" + this.delegate + ", callback=" + this.callback + "}";
        }
    }
}

