/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.ProducesJson;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.prometheus.client.CollectorRegistry;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthStatusHttpMapper;
import org.springframework.boot.actuate.health.Status;

public class MetricsHealthController {
    final MeterRegistry meterRegistry;
    final HealthEndpoint healthEndpoint;
    final HealthStatusHttpMapper statusMapper;
    final CollectorRegistry collectorRegistry;
    final ObjectMapper mapper;
    final JsonNodeFactory factory = JsonNodeFactory.instance;

    MetricsHealthController(MeterRegistry meterRegistry, HealthEndpoint healthEndpoint, HealthStatusHttpMapper statusMapper, CollectorRegistry collectorRegistry, ObjectMapper mapper) {
        this.meterRegistry = meterRegistry;
        this.healthEndpoint = healthEndpoint;
        this.statusMapper = statusMapper;
        this.collectorRegistry = collectorRegistry;
        this.mapper = mapper;
    }

    @Get(value="/metrics")
    @ProducesJson
    public ObjectNode fetchMetricsFromMicrometer() {
        ObjectNode metricsJson = this.factory.objectNode();
        for (Meter meter : this.meterRegistry.getMeters()) {
            String transport;
            String name = meter.getId().getName();
            if (!name.startsWith("zipkin_collector") || (transport = meter.getId().getTag("transport")) == null) continue;
            Meter.Type type = meter.getId().getType();
            if (type == Meter.Type.COUNTER) {
                metricsJson.put("counter." + name + "." + transport, ((Counter)meter).count());
                continue;
            }
            if (type != Meter.Type.GAUGE) continue;
            metricsJson.put("gauge." + name + "." + transport, ((Gauge)meter).value());
        }
        return metricsJson;
    }

    @Get(value="/health")
    public CompletableFuture<HttpResponse> getHealth(ServiceRequestContext ctx) {
        CompletableFuture<HttpResponse> responseFuture = new CompletableFuture<HttpResponse>();
        ctx.setRequestTimeoutHandler(() -> {
            LinkedHashMap<String, Object> healthJson = new LinkedHashMap<String, Object>();
            healthJson.put("status", Status.DOWN);
            healthJson.put("zipkin", "Timed out computing health status. This often means your storage backend is unreachable.");
            try {
                responseFuture.complete(HttpResponse.of((AggregatedHttpResponse)this.constructHealthResponse(Status.DOWN, healthJson)));
            }
            catch (IOException e) {
                responseFuture.completeExceptionally(e);
            }
        });
        ctx.blockingTaskExecutor().execute(() -> {
            Health health = this.healthEndpoint.health();
            LinkedHashMap<String, Object> healthJson = new LinkedHashMap<String, Object>();
            healthJson.put("status", health.getStatus().getCode());
            healthJson.put("zipkin", health.getDetails().get("zipkin"));
            try {
                responseFuture.complete(HttpResponse.of((AggregatedHttpResponse)this.constructHealthResponse(health.getStatus(), healthJson)));
            }
            catch (IOException e) {
                responseFuture.completeExceptionally(e);
                return;
            }
        });
        return responseFuture;
    }

    private AggregatedHttpResponse constructHealthResponse(Status status, Map<String, Object> healthJson) throws IOException {
        byte[] body = this.mapper.writeValueAsBytes(healthJson);
        ResponseHeaders headers = ResponseHeaders.builder((int)this.statusMapper.mapStatus(status)).contentType(MediaType.JSON).setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, body.length).build();
        return AggregatedHttpResponse.of((ResponseHeaders)headers, (HttpData)HttpData.wrap((byte[])body));
    }
}

