/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.CacheControl;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ServerCacheControl;
import com.linecorp.armeria.common.ServerCacheControlBuilder;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.RedirectService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.file.HttpFileBuilder;
import com.linecorp.armeria.server.file.HttpFileServiceBuilder;
import com.linecorp.armeria.spring.ArmeriaServerConfigurator;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import zipkin2.server.internal.ui.CompressionProperties;
import zipkin2.server.internal.ui.ZipkinUiProperties;

@Configuration
@EnableConfigurationProperties(value={ZipkinUiProperties.class, CompressionProperties.class})
@ConditionalOnProperty(name={"zipkin.ui.enabled"}, matchIfMissing=true)
public class ZipkinUiConfiguration {
    @Autowired
    ZipkinUiProperties ui;
    @Value(value="classpath:zipkin-ui/index.html")
    Resource indexHtml;
    @Value(value="classpath:zipkin-lens/index.html")
    Resource lensIndexHtml;

    @Bean
    @Lazy
    String processedIndexHtml() throws IOException {
        return this.processedIndexHtml(this.indexHtml);
    }

    @Bean
    @Lazy
    String processedLensIndexHtml() throws IOException {
        return this.processedIndexHtml(this.lensIndexHtml);
    }

    String processedIndexHtml(Resource indexHtml) throws IOException {
        String baseTagValue = "/".equals(this.ui.getBasepath()) ? "/" : this.ui.getBasepath() + "/";
        char[] buffer = new char[1024];
        StringBuilder builder = new StringBuilder();
        try (InputStream fromClasspath = indexHtml.getInputStream();
             InputStreamReader reader = new InputStreamReader(fromClasspath, StandardCharsets.UTF_8);){
            int read;
            while ((read = reader.read(buffer, 0, buffer.length)) >= 0) {
                builder.append(buffer, 0, read);
            }
        }
        String beforeReplacement = builder.toString();
        return beforeReplacement.replaceAll("base href=\"[^\"]+\"", "base href=\"" + baseTagValue + "\"");
    }

    @Bean
    @Lazy
    IndexSwitchingService indexSwitchingService() throws IOException {
        HttpFileBuilder lensIndex;
        HttpFileBuilder legacyIndex;
        if ("/zipkin".equals(this.ui.getBasepath())) {
            legacyIndex = HttpFileBuilder.ofResource((String)"zipkin-ui/index.html");
            lensIndex = HttpFileBuilder.ofResource((String)"zipkin-lens/index.html");
        } else {
            legacyIndex = HttpFileBuilder.of((HttpData)HttpData.wrap((byte[])this.processedIndexHtml().getBytes(StandardCharsets.UTF_8)));
            lensIndex = HttpFileBuilder.of((HttpData)HttpData.wrap((byte[])this.processedLensIndexHtml().getBytes(StandardCharsets.UTF_8)));
        }
        ServerCacheControl maxAgeMinute = new ServerCacheControlBuilder().maxAgeSeconds(60L).build();
        legacyIndex.contentType(MediaType.HTML_UTF_8).cacheControl((CacheControl)maxAgeMinute);
        lensIndex.contentType(MediaType.HTML_UTF_8).cacheControl((CacheControl)maxAgeMinute);
        return new IndexSwitchingService(legacyIndex.build().asService(), lensIndex.build().asService());
    }

    @Bean
    @Lazy
    ArmeriaServerConfigurator uiServerConfigurator(IndexSwitchingService indexSwitchingService) throws IOException {
        IndexSwitchingService indexService = this.indexHtml.isReadable() ? indexSwitchingService : indexSwitchingService.lensIndex;
        ServerCacheControl maxAgeYear = new ServerCacheControlBuilder().maxAgeSeconds(TimeUnit.DAYS.toSeconds(365L)).build();
        HttpService uiFileService = HttpFileServiceBuilder.forClassPath((String)"zipkin-ui").cacheControl((CacheControl)maxAgeYear).build().orElse((Service)HttpFileServiceBuilder.forClassPath((String)"zipkin-lens").cacheControl((CacheControl)maxAgeYear).build());
        byte[] config = new ObjectMapper().writeValueAsBytes((Object)this.ui);
        return arg_0 -> ZipkinUiConfiguration.lambda$uiServerConfigurator$0(config, (Service)uiFileService, (HttpService)indexService, arg_0);
    }

    @Bean
    Consumer<MeterRegistry.Config> noFaviconMetrics() {
        return config -> config.meterFilter(MeterFilter.deny(id -> {
            String uri = id.getTag("uri");
            return uri != null && uri.startsWith("/favicon.ico");
        }));
    }

    private static /* synthetic */ void lambda$uiServerConfigurator$0(byte[] config, Service uiFileService, HttpService indexService, ServerBuilder sb) {
        sb.service("/zipkin/config.json", (Service)HttpFileBuilder.of((HttpData)HttpData.wrap((byte[])config)).cacheControl((CacheControl)new ServerCacheControlBuilder().maxAgeSeconds(600L).build()).contentType(MediaType.JSON_UTF_8).build().asService());
        sb.serviceUnder("/zipkin/", uiFileService);
        sb.service("/zipkin/", (Service)indexService).service("/zipkin/index.html", (Service)indexService).service("/zipkin/traces/{id}", (Service)indexService).service("/zipkin/dependency", (Service)indexService).service("/zipkin/traceViewer", (Service)indexService);
        sb.service("/favicon.ico", (Service)new RedirectService(HttpStatus.FOUND, "/zipkin/favicon.ico")).service("/", (Service)new RedirectService(HttpStatus.FOUND, "/zipkin/")).service("/zipkin", (Service)new RedirectService(HttpStatus.FOUND, "/zipkin/"));
    }

    static class IndexSwitchingService
    extends AbstractHttpService {
        final HttpService legacyIndex;
        final HttpService lensIndex;

        IndexSwitchingService(HttpService legacyIndex, HttpService lensIndex) {
            this.legacyIndex = legacyIndex;
            this.lensIndex = lensIndex;
        }

        public HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) throws Exception {
            Set cookies = ServerCookieDecoder.LAX.decode(req.headers().get((CharSequence)HttpHeaderNames.COOKIE, ""));
            for (Cookie cookie : cookies) {
                if (!cookie.name().equals("lens") || !Boolean.parseBoolean(cookie.value())) continue;
                return this.lensIndex.serve(ctx, req);
            }
            return this.legacyIndex.serve(ctx, req);
        }
    }
}

