/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.health;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Get;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import zipkin2.Component;
import zipkin2.server.internal.ZipkinHttpConfiguration;
import zipkin2.server.internal.health.ComponentHealth;

public class ZipkinHealthController {
    static final JsonFactory JSON_FACTORY = new JsonFactory();
    final List<Component> components;

    ZipkinHealthController(List<Component> components) {
        this.components = components;
    }

    @Get(value="/actuator/health")
    public CompletableFuture<HttpResponse> getActuatorHealth(ServiceRequestContext ctx) {
        return this.health(ctx, ZipkinHttpConfiguration.MEDIA_TYPE_ACTUATOR);
    }

    @Get(value="/health")
    public CompletableFuture<HttpResponse> getHealth(ServiceRequestContext ctx) {
        return this.health(ctx, MediaType.JSON_UTF_8);
    }

    CompletableFuture<HttpResponse> health(ServiceRequestContext ctx, MediaType mediaType) {
        CompletableFuture<HttpResponse> responseFuture = new CompletableFuture<HttpResponse>();
        ctx.setRequestTimeoutHandler(() -> {
            try {
                String healthJson = ZipkinHealthController.writeJsonError("Timed out computing health status. This often means your storage backend is unreachable.");
                responseFuture.complete(ZipkinHealthController.newHealthResponse("DOWN", mediaType, healthJson));
            }
            catch (Throwable e) {
                responseFuture.completeExceptionally(e);
            }
        });
        ctx.blockingTaskExecutor().execute(() -> {
            try {
                responseFuture.complete(ZipkinHealthController.newHealthResponse(ZipkinHealthController.componentHealths(this.components), mediaType));
            }
            catch (Throwable e) {
                responseFuture.completeExceptionally(e);
            }
        });
        return responseFuture;
    }

    static List<ComponentHealth> componentHealths(List<Component> components) {
        return ((Stream)components.stream().parallel()).map(ComponentHealth::ofComponent).collect(Collectors.toList());
    }

    static HttpResponse newHealthResponse(List<ComponentHealth> healths, MediaType mediaType) throws IOException {
        String overallStatus = "UP";
        for (ComponentHealth health : healths) {
            if (!health.status.equals("DOWN")) continue;
            overallStatus = "DOWN";
        }
        String healthJson = ZipkinHealthController.writeJson(overallStatus, healths);
        return ZipkinHealthController.newHealthResponse(overallStatus, mediaType, healthJson);
    }

    static HttpResponse newHealthResponse(String status, MediaType mediaType, String healthJson) {
        HttpStatus code = status.equals("UP") ? HttpStatus.OK : HttpStatus.SERVICE_UNAVAILABLE;
        return HttpResponse.of((HttpStatus)code, (MediaType)mediaType, (String)healthJson);
    }

    static String writeJsonError(String error) throws IOException {
        StringWriter writer = new StringWriter();
        try (JsonGenerator generator = JSON_FACTORY.createGenerator((Writer)writer);){
            generator.useDefaultPrettyPrinter();
            generator.writeStartObject();
            generator.writeStringField("status", "DOWN");
            generator.writeObjectFieldStart("zipkin");
            generator.writeStringField("status", "DOWN");
            generator.writeObjectFieldStart("details");
            generator.writeStringField("error", error);
            generator.writeEndObject();
            generator.writeEndObject();
            generator.writeEndObject();
        }
        return writer.toString();
    }

    static String writeJson(String overallStatus, List<ComponentHealth> healths) throws IOException {
        StringWriter writer = new StringWriter();
        try (JsonGenerator generator = JSON_FACTORY.createGenerator((Writer)writer);){
            generator.useDefaultPrettyPrinter();
            generator.writeStartObject();
            generator.writeStringField("status", overallStatus);
            generator.writeObjectFieldStart("zipkin");
            generator.writeStringField("status", overallStatus);
            generator.writeObjectFieldStart("details");
            for (ComponentHealth health : healths) {
                generator.writeObjectFieldStart(health.name);
                generator.writeStringField("status", health.status);
                if (health.status.equals("DOWN")) {
                    generator.writeObjectFieldStart("details");
                    generator.writeStringField("error", health.error);
                    generator.writeEndObject();
                }
                generator.writeEndObject();
            }
            generator.writeEndObject();
            generator.writeEndObject();
            generator.writeEndObject();
        }
        return writer.toString();
    }
}

