/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.brave;

import brave.Tracer;
import brave.Tracing;
import brave.context.slf4j.MDCScopeDecorator;
import brave.http.HttpTracing;
import brave.propagation.B3SinglePropagation;
import brave.propagation.CurrentTraceContext;
import brave.propagation.ThreadLocalSpan;
import brave.sampler.BoundarySampler;
import brave.sampler.RateLimitingSampler;
import brave.sampler.Sampler;
import com.linecorp.armeria.common.brave.RequestContextCurrentTraceContext;
import com.linecorp.armeria.server.brave.BraveService;
import com.linecorp.armeria.spring.ArmeriaServerConfigurator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import zipkin2.Call;
import zipkin2.CheckResult;
import zipkin2.Span;
import zipkin2.codec.Encoding;
import zipkin2.codec.SpanBytesDecoder;
import zipkin2.collector.CollectorMetrics;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.ReporterMetrics;
import zipkin2.reporter.Sender;
import zipkin2.server.internal.ConditionalOnSelfTracing;
import zipkin2.server.internal.brave.SelfTracingProperties;
import zipkin2.server.internal.brave.TracingStorageComponent;
import zipkin2.storage.StorageComponent;

@EnableConfigurationProperties(value={SelfTracingProperties.class})
@ConditionalOnSelfTracing
public class ZipkinSelfTracingConfiguration {
    @Bean
    Reporter<Span> reporter(BeanFactory factory, SelfTracingProperties config) {
        return AsyncReporter.builder((Sender)new LocalSender(factory)).threadFactory(runnable -> new Thread(new Runnable(){

            @Override
            public void run() {
                RequestContextCurrentTraceContext.setCurrentThreadNotRequestThread((boolean)true);
                runnable.run();
            }

            public String toString() {
                return runnable.toString();
            }
        })).messageTimeout(config.getMessageTimeout().toNanos(), TimeUnit.NANOSECONDS).metrics((ReporterMetrics)new ReporterMetricsAdapter(factory)).build();
    }

    @Bean
    CurrentTraceContext currentTraceContext() {
        return RequestContextCurrentTraceContext.builder().addScopeDecorator(MDCScopeDecorator.create()).build();
    }

    @Bean
    ThreadLocalSpan threadLocalSpan(Tracing tracing) {
        return ThreadLocalSpan.create((Tracer)tracing.tracer());
    }

    @Bean
    Sampler sampler(SelfTracingProperties config) {
        if ((double)config.getSampleRate() != 1.0) {
            if ((double)config.getSampleRate() < 0.01) {
                return BoundarySampler.create((float)config.getSampleRate());
            }
            return Sampler.create((float)config.getSampleRate());
        }
        if (config.getTracesPerSecond() != 0) {
            return RateLimitingSampler.create((int)config.getTracesPerSecond());
        }
        return Sampler.ALWAYS_SAMPLE;
    }

    @Bean
    Tracing tracing(Reporter<Span> reporter, CurrentTraceContext currentTraceContext) {
        return Tracing.newBuilder().localServiceName("zipkin-server").sampler(Sampler.NEVER_SAMPLE).currentTraceContext(currentTraceContext).propagationFactory(B3SinglePropagation.FACTORY).spanReporter(reporter).build();
    }

    @Bean
    HttpTracing httpTracing(Tracing tracing, Sampler sampler) {
        return HttpTracing.newBuilder((Tracing)tracing).serverSampler(request -> {
            String path = request.path();
            if (path.startsWith("/api") || path.startsWith("/zipkin/api")) {
                return sampler.isSampled(0L);
            }
            return false;
        }).build();
    }

    @Bean
    ArmeriaServerConfigurator tracingConfigurator(HttpTracing tracing) {
        return server -> server.decorator(BraveService.newDecorator((HttpTracing)tracing));
    }

    static final class ReporterMetricsAdapter
    implements ReporterMetrics {
        final BeanFactory factory;
        volatile CollectorMetrics delegate;

        ReporterMetricsAdapter(BeanFactory factory) {
            this.factory = factory;
        }

        public void incrementMessages() {
            this.delegate().incrementMessages();
        }

        public void incrementMessagesDropped(Throwable throwable) {
            this.delegate().incrementMessagesDropped();
        }

        public void incrementSpans(int i) {
            this.delegate().incrementSpans(i);
        }

        public void incrementSpanBytes(int i) {
            this.delegate().incrementBytes(i);
        }

        public void incrementMessageBytes(int i) {
        }

        public void incrementSpansDropped(int i) {
            this.delegate().incrementMessagesDropped();
        }

        public void updateQueuedSpans(int i) {
        }

        public void updateQueuedBytes(int i) {
        }

        CollectorMetrics delegate() {
            CollectorMetrics result = this.delegate;
            if (result != null) {
                return this.delegate;
            }
            this.delegate = ((CollectorMetrics)this.factory.getBean(CollectorMetrics.class)).forTransport("local");
            return this.delegate;
        }
    }

    static final class LocalSender
    extends Sender {
        final BeanFactory factory;
        volatile StorageComponent delegate;

        LocalSender(BeanFactory factory) {
            this.factory = factory;
        }

        public Encoding encoding() {
            return Encoding.PROTO3;
        }

        public int messageMaxBytes() {
            return 0x500000;
        }

        public int messageSizeInBytes(List<byte[]> list) {
            return Encoding.PROTO3.listSizeInBytes(list);
        }

        public Call<Void> sendSpans(List<byte[]> encodedSpans) {
            ArrayList<Span> spans = new ArrayList<Span>(encodedSpans.size());
            for (byte[] encodedSpan : encodedSpans) {
                Span v2Span = (Span)SpanBytesDecoder.PROTO3.decodeOne(encodedSpan);
                spans.add(v2Span);
            }
            return this.delegate().spanConsumer().accept(spans);
        }

        public CheckResult check() {
            return this.delegate().check();
        }

        public String toString() {
            return "StorageComponent";
        }

        public void close() {
        }

        StorageComponent delegate() {
            StorageComponent result = this.delegate;
            if (result != null) {
                return this.delegate;
            }
            result = (StorageComponent)this.factory.getBean(StorageComponent.class);
            if (result instanceof TracingStorageComponent) {
                result = ((TracingStorageComponent)result).delegate;
            }
            this.delegate = result;
            return this.delegate;
        }
    }
}

