/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.prometheus;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingService;
import com.linecorp.armeria.spring.ArmeriaServerConfigurator;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.netty.util.AttributeKey;
import io.prometheus.client.CollectorRegistry;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
public class ZipkinPrometheusMetricsConfiguration {
    private static final Tag URI_NOT_FOUND = Tag.of((String)"uri", (String)"NOT_FOUND");
    private static final Tag URI_REDIRECTION = Tag.of((String)"uri", (String)"REDIRECTION");
    private static final Tag URI_TRACE_V2 = Tag.of((String)"uri", (String)"/api/v2/trace/{traceId}");
    private static final Tag URI_CROSSROADS = Tag.of((String)"uri", (String)"/zipkin/index.html");
    final String metricName;
    private static final AttributeKey<Boolean> PROMETHEUS_METRICS_SET = AttributeKey.valueOf(Boolean.class, (String)"PROMETHEUS_METRICS_SET");

    ZipkinPrometheusMetricsConfiguration(@Value(value="${management.metrics.web.server.requests-metric-name:http.server.requests}") String metricName) {
        this.metricName = metricName;
    }

    @Bean
    @ConditionalOnMissingBean
    public Clock clock() {
        return Clock.SYSTEM;
    }

    @Bean
    @ConditionalOnMissingBean
    public PrometheusConfig config() {
        return PrometheusConfig.DEFAULT;
    }

    @Bean
    @ConditionalOnMissingBean
    public CollectorRegistry registry() {
        return new CollectorRegistry(true);
    }

    @Bean
    @ConditionalOnMissingBean
    public PrometheusMeterRegistry prometheusMeterRegistry(PrometheusConfig config, CollectorRegistry registry, Clock clock) {
        return new PrometheusMeterRegistry(config, registry, clock);
    }

    @Bean
    ArmeriaServerConfigurator httpRequestDurationConfigurator(MeterRegistry registry) {
        return serverBuilder -> serverBuilder.decorator(s -> new MetricCollectingService(s, registry, this.metricName));
    }

    @Bean
    @Order(value=1)
    ArmeriaServerConfigurator notFoundMetricCollector() {
        return sb -> sb.service(Route.builder().glob("/**").build(), (ctx, req) -> HttpResponse.of((HttpStatus)HttpStatus.NOT_FOUND));
    }

    public static void setup(RequestContext ctx, MeterRegistry registry, String metricName) {
        if (ctx.hasAttr(PROMETHEUS_METRICS_SET)) {
            return;
        }
        ctx.attr(PROMETHEUS_METRICS_SET).set((Object)true);
        ctx.log().addListener(log -> ZipkinPrometheusMetricsConfiguration.onRequest(log, registry, metricName), new RequestLogAvailability[]{RequestLogAvailability.REQUEST_HEADERS, RequestLogAvailability.REQUEST_CONTENT});
    }

    private static void onRequest(RequestLog log, MeterRegistry registry, String metricName) {
        Clock clock = registry.config().clock();
        long startTime = clock.monotonicTime();
        log.addListener(requestLog -> ZipkinPrometheusMetricsConfiguration.getTimeBuilder(requestLog, metricName).register(registry).record(clock.monotonicTime() - startTime, TimeUnit.NANOSECONDS), RequestLogAvailability.COMPLETE);
    }

    private static Timer.Builder getTimeBuilder(RequestLog requestLog, String metricName) {
        return Timer.builder((String)metricName).tags(ZipkinPrometheusMetricsConfiguration.getTags(requestLog)).description("Response time histogram").publishPercentileHistogram();
    }

    private static Iterable<Tag> getTags(RequestLog requestLog) {
        return Arrays.asList(Tag.of((String)"method", (String)requestLog.method().toString()), ZipkinPrometheusMetricsConfiguration.uri(requestLog), Tag.of((String)"status", (String)Integer.toString(requestLog.statusCode())));
    }

    private static Tag uri(RequestLog requestLog) {
        int status = requestLog.statusCode();
        if (status > 299 && status < 400) {
            return URI_REDIRECTION;
        }
        if (status == 404) {
            return URI_NOT_FOUND;
        }
        String uri = ZipkinPrometheusMetricsConfiguration.getPathInfo(requestLog);
        if (uri.startsWith("/zipkin")) {
            if (uri.equals("/zipkin/") || uri.equals("/zipkin") || uri.startsWith("/zipkin/traces/") || uri.equals("/zipkin/dependency") || uri.equals("/zipkin/traceViewer")) {
                return URI_CROSSROADS;
            }
            if (uri.startsWith("/zipkin/api")) {
                uri = uri.replaceFirst("/zipkin", "");
            }
        }
        if (uri.startsWith("/api/v2/trace/")) {
            return URI_TRACE_V2;
        }
        return Tag.of((String)"uri", (String)uri);
    }

    static String getPathInfo(RequestLog requestLog) {
        String uri = requestLog.path();
        if (!StringUtils.hasText((String)uri)) {
            return "/";
        }
        return uri.replaceAll("//+", "/").replaceAll("/$", "");
    }

    static final class MetricCollectingService<I extends Request, O extends Response>
    extends SimpleDecoratingService<I, O> {
        final MeterRegistry registry;
        final String metricName;

        MetricCollectingService(Service<I, O> delegate, MeterRegistry registry, String metricName) {
            super(delegate);
            this.registry = registry;
            this.metricName = metricName;
        }

        public O serve(ServiceRequestContext ctx, I req) throws Exception {
            ZipkinPrometheusMetricsConfiguration.setup((RequestContext)ctx, this.registry, this.metricName);
            return (O)((Service)this.delegate()).serve(ctx, req);
        }
    }
}

