// Code generated by Wire protocol buffer compiler, do not edit.
// Source file: zipkin.proto
package zipkin2.proto3;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import okio.ByteString;

/**
 * Associates an event that explains latency with a timestamp.
 * Unlike log statements, annotations are often codes. Ex. "ws" for WireSend
 *
 * The next id is 3.
 */
public final class Annotation extends Message<Annotation, Annotation.Builder> {
  public static final ProtoAdapter<Annotation> ADAPTER = new ProtoAdapter_Annotation();

  private static final long serialVersionUID = 0L;

  public static final Long DEFAULT_TIMESTAMP = 0L;

  public static final String DEFAULT_VALUE = "";

  /**
   * Epoch microseconds of this event.
   *
   * For example, 1502787600000000 corresponds to 2017-08-15 09:00 UTC
   *
   * This value should be set directly by instrumentation, using the most
   * precise value possible. For example, gettimeofday or multiplying epoch
   * millis by 1000.
   */
  @WireField(
      tag = 1,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64"
  )
  public final Long timestamp;

  /**
   * Usually a short tag indicating an event, like "error"
   *
   * While possible to add larger data, such as garbage collection details, low
   * cardinality event names both keep the size of spans down and also are easy
   * to search against.
   */
  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#STRING"
  )
  public final String value;

  public Annotation(Long timestamp, String value) {
    this(timestamp, value, ByteString.EMPTY);
  }

  public Annotation(Long timestamp, String value, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.timestamp = timestamp;
    this.value = value;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.timestamp = timestamp;
    builder.value = value;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof Annotation)) return false;
    Annotation o = (Annotation) other;
    return unknownFields().equals(o.unknownFields())
        && Internal.equals(timestamp, o.timestamp)
        && Internal.equals(value, o.value);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + (timestamp != null ? timestamp.hashCode() : 0);
      result = result * 37 + (value != null ? value.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (timestamp != null) builder.append(", timestamp=").append(timestamp);
    if (value != null) builder.append(", value=").append(value);
    return builder.replace(0, 2, "Annotation{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<Annotation, Builder> {
    public Long timestamp;

    public String value;

    public Builder() {
    }

    /**
     * Epoch microseconds of this event.
     *
     * For example, 1502787600000000 corresponds to 2017-08-15 09:00 UTC
     *
     * This value should be set directly by instrumentation, using the most
     * precise value possible. For example, gettimeofday or multiplying epoch
     * millis by 1000.
     */
    public Builder timestamp(Long timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    /**
     * Usually a short tag indicating an event, like "error"
     *
     * While possible to add larger data, such as garbage collection details, low
     * cardinality event names both keep the size of spans down and also are easy
     * to search against.
     */
    public Builder value(String value) {
      this.value = value;
      return this;
    }

    @Override
    public Annotation build() {
      return new Annotation(timestamp, value, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_Annotation extends ProtoAdapter<Annotation> {
    public ProtoAdapter_Annotation() {
      super(FieldEncoding.LENGTH_DELIMITED, Annotation.class);
    }

    @Override
    public int encodedSize(Annotation value) {
      return ProtoAdapter.FIXED64.encodedSizeWithTag(1, value.timestamp)
          + ProtoAdapter.STRING.encodedSizeWithTag(2, value.value)
          + value.unknownFields().size();
    }

    @Override
    public void encode(ProtoWriter writer, Annotation value) throws IOException {
      ProtoAdapter.FIXED64.encodeWithTag(writer, 1, value.timestamp);
      ProtoAdapter.STRING.encodeWithTag(writer, 2, value.value);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public Annotation decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.timestamp(ProtoAdapter.FIXED64.decode(reader)); break;
          case 2: builder.value(ProtoAdapter.STRING.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public Annotation redact(Annotation value) {
      Builder builder = value.newBuilder();
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
