/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin2.server.internal.ZipkinHttpCollector;

final class BodyIsExceptionMessage
implements ExceptionHandlerFunction {
    static final Logger LOGGER = LoggerFactory.getLogger(BodyIsExceptionMessage.class);

    BodyIsExceptionMessage() {
    }

    public HttpResponse handleException(ServiceRequestContext ctx, HttpRequest req, Throwable cause) {
        String message;
        if (req.method() == HttpMethod.POST && req.path().startsWith("/api/v")) {
            ZipkinHttpCollector.metrics.incrementMessagesDropped();
        }
        if ((message = cause.getMessage()) == null) {
            message = cause.getClass().getSimpleName();
        }
        if (cause instanceof IllegalArgumentException) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.ANY_TEXT_TYPE, (String)message);
        }
        LOGGER.warn("Unexpected error handling request.", cause);
        return HttpResponse.of((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (MediaType)MediaType.ANY_TEXT_TYPE, (String)message);
    }
}

