// Code generated by Wire protocol buffer compiler, do not edit.
// Source file: zipkin.proto
package zipkin2.proto3;

import com.squareup.wire.EnumAdapter;
import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireEnum;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okio.ByteString;

/**
 * A span is a single-host view of an operation. A trace is a series of spans
 * (often RPC calls) which nest to form a latency tree. Spans are in the same
 * trace when they share the same trace ID. The parent_id field establishes the
 * position of one span in the tree.
 *
 * The root span is where parent_id is Absent and usually has the longest
 * duration in the trace. However, nested asynchronous work can materialize as
 * child spans whose duration exceed the root span.
 *
 * Spans usually represent remote activity such as RPC calls, or messaging
 * producers and consumers. However, they can also represent in-process
 * activity in any position of the trace. For example, a root span could
 * represent a server receiving an initial client request. A root span could
 * also represent a scheduled job that has no remote context.
 *
 * Encoding notes:
 *
 * Epoch timestamp are encoded fixed64 as varint would also be 8 bytes, and more
 * expensive to encode and size. Duration is stored uint64, as often the numbers
 * are quite small.
 *
 * Default values are ok, as only natural numbers are used. For example, zero is
 * an invalid timestamp and an invalid duration, false values for debug or shared
 * are ignorable, and zero-length strings also coerce to null.
 *
 * The next id is 14.
 *
 * Note fields up to 15 take 1 byte to encode. Take care when adding new fields
 * https://developers.google.com/protocol-buffers/docs/proto3#assigning-tags
 */
public final class Span extends Message<Span, Span.Builder> {
  public static final ProtoAdapter<Span> ADAPTER = new ProtoAdapter_Span();

  private static final long serialVersionUID = 0L;

  /**
   * Randomly generated, unique identifier for a trace, set on all spans within
   * it.
   *
   * This field is required and encoded as 8 or 16 bytes, in big endian byte
   * order.
   */
  @WireField(
      tag = 1,
      adapter = "com.squareup.wire.ProtoAdapter#BYTES",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "traceId"
  )
  public final ByteString trace_id;

  /**
   * The parent span ID or absent if this the root span in a trace.
   */
  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#BYTES",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "parentId"
  )
  public final ByteString parent_id;

  /**
   * Unique identifier for this operation within the trace.
   *
   * This field is required and encoded as 8 opaque bytes.
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#BYTES",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final ByteString id;

  /**
   * When present, used to interpret remote_endpoint
   */
  @WireField(
      tag = 4,
      adapter = "zipkin2.proto3.Span$Kind#ADAPTER",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final Kind kind;

  /**
   * The logical operation this span represents in lowercase (e.g. rpc method).
   * Leave absent if unknown.
   *
   * As these are lookup labels, take care to ensure names are low cardinality.
   * For example, do not embed variables into the name.
   */
  @WireField(
      tag = 5,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final String name;

  /**
   * Epoch microseconds of the start of this span, possibly absent if
   * incomplete.
   *
   * For example, 1502787600000000 corresponds to 2017-08-15 09:00 UTC
   *
   * This value should be set directly by instrumentation, using the most
   * precise value possible. For example, gettimeofday or multiplying epoch
   * millis by 1000.
   *
   * There are three known edge-cases where this could be reported absent.
   * - A span was allocated but never started (ex not yet received a timestamp)
   * - The span's start event was lost
   * - Data about a completed span (ex tags) were sent after the fact
   */
  @WireField(
      tag = 6,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final long timestamp;

  /**
   * Duration in microseconds of the critical path, if known. Durations of less
   * than one are rounded up. Duration of children can be longer than their
   * parents due to asynchronous operations.
   *
   * For example 150 milliseconds is 150000 microseconds.
   */
  @WireField(
      tag = 7,
      adapter = "com.squareup.wire.ProtoAdapter#UINT64",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final long duration;

  /**
   * The host that recorded this span, primarily for query by service name.
   *
   * Instrumentation should always record this. Usually, absent implies late
   * data. The IP address corresponding to this is usually the site local or
   * advertised service address. When present, the port indicates the listen
   * port.
   */
  @WireField(
      tag = 8,
      adapter = "zipkin2.proto3.Endpoint#ADAPTER",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "localEndpoint"
  )
  public final Endpoint local_endpoint;

  /**
   * When an RPC (or messaging) span, indicates the other side of the
   * connection.
   *
   * By recording the remote endpoint, your trace will contain network context
   * even if the peer is not tracing. For example, you can record the IP from
   * the "X-Forwarded-For" header or the service name and socket of a remote
   * peer.
   */
  @WireField(
      tag = 9,
      adapter = "zipkin2.proto3.Endpoint#ADAPTER",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "remoteEndpoint"
  )
  public final Endpoint remote_endpoint;

  /**
   * Associates events that explain latency with the time they happened.
   */
  @WireField(
      tag = 10,
      adapter = "zipkin2.proto3.Annotation#ADAPTER",
      label = WireField.Label.REPEATED
  )
  public final List<Annotation> annotations;

  /**
   * Tags give your span context for search, viewing and analysis.
   *
   * For example, a key "your_app.version" would let you lookup traces by
   * version. A tag "sql.query" isn't searchable, but it can help in debugging
   * when viewing a trace.
   */
  @WireField(
      tag = 11,
      keyAdapter = "com.squareup.wire.ProtoAdapter#STRING",
      adapter = "com.squareup.wire.ProtoAdapter#STRING"
  )
  public final Map<String, String> tags;

  /**
   * True is a request to store this span even if it overrides sampling policy.
   *
   * This is true when the "X-B3-Flags" header has a value of 1.
   */
  @WireField(
      tag = 12,
      adapter = "com.squareup.wire.ProtoAdapter#BOOL",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final boolean debug;

  /**
   * True if we are contributing to a span started by another tracer (ex on a
   * different host).
   */
  @WireField(
      tag = 13,
      adapter = "com.squareup.wire.ProtoAdapter#BOOL",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final boolean shared;

  public Span(ByteString trace_id, ByteString parent_id, ByteString id, Kind kind, String name,
      long timestamp, long duration, Endpoint local_endpoint, Endpoint remote_endpoint,
      List<Annotation> annotations, Map<String, String> tags, boolean debug, boolean shared) {
    this(trace_id, parent_id, id, kind, name, timestamp, duration, local_endpoint, remote_endpoint, annotations, tags, debug, shared, ByteString.EMPTY);
  }

  public Span(ByteString trace_id, ByteString parent_id, ByteString id, Kind kind, String name,
      long timestamp, long duration, Endpoint local_endpoint, Endpoint remote_endpoint,
      List<Annotation> annotations, Map<String, String> tags, boolean debug, boolean shared,
      ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    if (trace_id == null) {
      throw new IllegalArgumentException("trace_id == null");
    }
    this.trace_id = trace_id;
    if (parent_id == null) {
      throw new IllegalArgumentException("parent_id == null");
    }
    this.parent_id = parent_id;
    if (id == null) {
      throw new IllegalArgumentException("id == null");
    }
    this.id = id;
    if (kind == null) {
      throw new IllegalArgumentException("kind == null");
    }
    this.kind = kind;
    if (name == null) {
      throw new IllegalArgumentException("name == null");
    }
    this.name = name;
    this.timestamp = timestamp;
    this.duration = duration;
    this.local_endpoint = local_endpoint;
    this.remote_endpoint = remote_endpoint;
    this.annotations = Internal.immutableCopyOf("annotations", annotations);
    this.tags = Internal.immutableCopyOf("tags", tags);
    this.debug = debug;
    this.shared = shared;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.trace_id = trace_id;
    builder.parent_id = parent_id;
    builder.id = id;
    builder.kind = kind;
    builder.name = name;
    builder.timestamp = timestamp;
    builder.duration = duration;
    builder.local_endpoint = local_endpoint;
    builder.remote_endpoint = remote_endpoint;
    builder.annotations = Internal.copyOf(annotations);
    builder.tags = Internal.copyOf(tags);
    builder.debug = debug;
    builder.shared = shared;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof Span)) return false;
    Span o = (Span) other;
    return unknownFields().equals(o.unknownFields())
        && Internal.equals(trace_id, o.trace_id)
        && Internal.equals(parent_id, o.parent_id)
        && Internal.equals(id, o.id)
        && Internal.equals(kind, o.kind)
        && Internal.equals(name, o.name)
        && Internal.equals(timestamp, o.timestamp)
        && Internal.equals(duration, o.duration)
        && Internal.equals(local_endpoint, o.local_endpoint)
        && Internal.equals(remote_endpoint, o.remote_endpoint)
        && annotations.equals(o.annotations)
        && tags.equals(o.tags)
        && Internal.equals(debug, o.debug)
        && Internal.equals(shared, o.shared);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + (trace_id != null ? trace_id.hashCode() : 0);
      result = result * 37 + (parent_id != null ? parent_id.hashCode() : 0);
      result = result * 37 + (id != null ? id.hashCode() : 0);
      result = result * 37 + (kind != null ? kind.hashCode() : 0);
      result = result * 37 + (name != null ? name.hashCode() : 0);
      result = result * 37 + Long.hashCode(timestamp);
      result = result * 37 + Long.hashCode(duration);
      result = result * 37 + (local_endpoint != null ? local_endpoint.hashCode() : 0);
      result = result * 37 + (remote_endpoint != null ? remote_endpoint.hashCode() : 0);
      result = result * 37 + annotations.hashCode();
      result = result * 37 + tags.hashCode();
      result = result * 37 + Boolean.hashCode(debug);
      result = result * 37 + Boolean.hashCode(shared);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (trace_id != null) builder.append(", trace_id=").append(trace_id);
    if (parent_id != null) builder.append(", parent_id=").append(parent_id);
    if (id != null) builder.append(", id=").append(id);
    if (kind != null) builder.append(", kind=").append(kind);
    if (name != null) builder.append(", name=").append(Internal.sanitize(name));
    builder.append(", timestamp=").append(timestamp);
    builder.append(", duration=").append(duration);
    if (local_endpoint != null) builder.append(", local_endpoint=").append(local_endpoint);
    if (remote_endpoint != null) builder.append(", remote_endpoint=").append(remote_endpoint);
    if (!annotations.isEmpty()) builder.append(", annotations=").append(annotations);
    if (!tags.isEmpty()) builder.append(", tags=").append(tags);
    builder.append(", debug=").append(debug);
    builder.append(", shared=").append(shared);
    return builder.replace(0, 2, "Span{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<Span, Builder> {
    public ByteString trace_id;

    public ByteString parent_id;

    public ByteString id;

    public Kind kind;

    public String name;

    public long timestamp;

    public long duration;

    public Endpoint local_endpoint;

    public Endpoint remote_endpoint;

    public List<Annotation> annotations;

    public Map<String, String> tags;

    public boolean debug;

    public boolean shared;

    public Builder() {
      trace_id = ByteString.EMPTY;
      parent_id = ByteString.EMPTY;
      id = ByteString.EMPTY;
      kind = Kind.SPAN_KIND_UNSPECIFIED;
      name = "";
      timestamp = 0L;
      duration = 0L;
      annotations = Internal.newMutableList();
      tags = Internal.newMutableMap();
      debug = false;
      shared = false;
    }

    /**
     * Randomly generated, unique identifier for a trace, set on all spans within
     * it.
     *
     * This field is required and encoded as 8 or 16 bytes, in big endian byte
     * order.
     */
    public Builder trace_id(ByteString trace_id) {
      this.trace_id = trace_id;
      return this;
    }

    /**
     * The parent span ID or absent if this the root span in a trace.
     */
    public Builder parent_id(ByteString parent_id) {
      this.parent_id = parent_id;
      return this;
    }

    /**
     * Unique identifier for this operation within the trace.
     *
     * This field is required and encoded as 8 opaque bytes.
     */
    public Builder id(ByteString id) {
      this.id = id;
      return this;
    }

    /**
     * When present, used to interpret remote_endpoint
     */
    public Builder kind(Kind kind) {
      this.kind = kind;
      return this;
    }

    /**
     * The logical operation this span represents in lowercase (e.g. rpc method).
     * Leave absent if unknown.
     *
     * As these are lookup labels, take care to ensure names are low cardinality.
     * For example, do not embed variables into the name.
     */
    public Builder name(String name) {
      this.name = name;
      return this;
    }

    /**
     * Epoch microseconds of the start of this span, possibly absent if
     * incomplete.
     *
     * For example, 1502787600000000 corresponds to 2017-08-15 09:00 UTC
     *
     * This value should be set directly by instrumentation, using the most
     * precise value possible. For example, gettimeofday or multiplying epoch
     * millis by 1000.
     *
     * There are three known edge-cases where this could be reported absent.
     * - A span was allocated but never started (ex not yet received a timestamp)
     * - The span's start event was lost
     * - Data about a completed span (ex tags) were sent after the fact
     */
    public Builder timestamp(long timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    /**
     * Duration in microseconds of the critical path, if known. Durations of less
     * than one are rounded up. Duration of children can be longer than their
     * parents due to asynchronous operations.
     *
     * For example 150 milliseconds is 150000 microseconds.
     */
    public Builder duration(long duration) {
      this.duration = duration;
      return this;
    }

    /**
     * The host that recorded this span, primarily for query by service name.
     *
     * Instrumentation should always record this. Usually, absent implies late
     * data. The IP address corresponding to this is usually the site local or
     * advertised service address. When present, the port indicates the listen
     * port.
     */
    public Builder local_endpoint(Endpoint local_endpoint) {
      this.local_endpoint = local_endpoint;
      return this;
    }

    /**
     * When an RPC (or messaging) span, indicates the other side of the
     * connection.
     *
     * By recording the remote endpoint, your trace will contain network context
     * even if the peer is not tracing. For example, you can record the IP from
     * the "X-Forwarded-For" header or the service name and socket of a remote
     * peer.
     */
    public Builder remote_endpoint(Endpoint remote_endpoint) {
      this.remote_endpoint = remote_endpoint;
      return this;
    }

    /**
     * Associates events that explain latency with the time they happened.
     */
    public Builder annotations(List<Annotation> annotations) {
      Internal.checkElementsNotNull(annotations);
      this.annotations = annotations;
      return this;
    }

    /**
     * Tags give your span context for search, viewing and analysis.
     *
     * For example, a key "your_app.version" would let you lookup traces by
     * version. A tag "sql.query" isn't searchable, but it can help in debugging
     * when viewing a trace.
     */
    public Builder tags(Map<String, String> tags) {
      Internal.checkElementsNotNull(tags);
      this.tags = tags;
      return this;
    }

    /**
     * True is a request to store this span even if it overrides sampling policy.
     *
     * This is true when the "X-B3-Flags" header has a value of 1.
     */
    public Builder debug(boolean debug) {
      this.debug = debug;
      return this;
    }

    /**
     * True if we are contributing to a span started by another tracer (ex on a
     * different host).
     */
    public Builder shared(boolean shared) {
      this.shared = shared;
      return this;
    }

    @Override
    public Span build() {
      return new Span(trace_id, parent_id, id, kind, name, timestamp, duration, local_endpoint, remote_endpoint, annotations, tags, debug, shared, super.buildUnknownFields());
    }
  }

  /**
   * When present, kind clarifies timestamp, duration and remote_endpoint. When
   * absent, the span is local or incomplete. Unlike client and server, there
   * is no direct critical path latency relationship between producer and
   * consumer spans.
   */
  public enum Kind implements WireEnum {
    /**
     * Default value interpreted as absent.
     */
    SPAN_KIND_UNSPECIFIED(0),

    /**
     * The span represents the client side of an RPC operation, implying the
     * following:
     *
     * timestamp is the moment a request was sent to the server.
     * duration is the delay until a response or an error was received.
     * remote_endpoint is the server.
     */
    CLIENT(1),

    /**
     * The span represents the server side of an RPC operation, implying the
     * following:
     *
     * timestamp is the moment a client request was received.
     * duration is the delay until a response was sent or an error.
     * remote_endpoint is the client.
     */
    SERVER(2),

    /**
     * The span represents production of a message to a remote broker, implying
     * the following:
     *
     * timestamp is the moment a message was sent to a destination.
     * duration is the delay sending the message, such as batching.
     * remote_endpoint is the broker.
     */
    PRODUCER(3),

    /**
     * The span represents consumption of a message from a remote broker, not
     * time spent servicing it. For example, a message processor would be an
     * in-process child span of a consumer. Consumer spans imply the following:
     *
     * timestamp is the moment a message was received from an origin.
     * duration is the delay consuming the message, such as from backlog.
     * remote_endpoint is the broker.
     */
    CONSUMER(4);

    public static final ProtoAdapter<Kind> ADAPTER = new ProtoAdapter_Kind();

    private final int value;

    Kind(int value) {
      this.value = value;
    }

    /**
     * Return the constant for {@code value} or null.
     */
    public static Kind fromValue(int value) {
      switch (value) {
        case 0: return SPAN_KIND_UNSPECIFIED;
        case 1: return CLIENT;
        case 2: return SERVER;
        case 3: return PRODUCER;
        case 4: return CONSUMER;
        default: return null;
      }
    }

    @Override
    public int getValue() {
      return value;
    }

    private static final class ProtoAdapter_Kind extends EnumAdapter<Kind> {
      ProtoAdapter_Kind() {
        super(Kind.class, Syntax.PROTO_3, Kind.SPAN_KIND_UNSPECIFIED);
      }

      @Override
      protected Kind fromValue(int value) {
        return Kind.fromValue(value);
      }
    }
  }

  private static final class ProtoAdapter_Span extends ProtoAdapter<Span> {
    private ProtoAdapter<Map<String, String>> tags;

    public ProtoAdapter_Span() {
      super(FieldEncoding.LENGTH_DELIMITED, Span.class, "type.googleapis.com/zipkin.proto3.Span", Syntax.PROTO_3, null, "zipkin.proto");
    }

    @Override
    public int encodedSize(Span value) {
      int result = 0;
      if (!Objects.equals(value.trace_id, ByteString.EMPTY)) {
        result += ProtoAdapter.BYTES.encodedSizeWithTag(1, value.trace_id);
      }
      if (!Objects.equals(value.parent_id, ByteString.EMPTY)) {
        result += ProtoAdapter.BYTES.encodedSizeWithTag(2, value.parent_id);
      }
      if (!Objects.equals(value.id, ByteString.EMPTY)) {
        result += ProtoAdapter.BYTES.encodedSizeWithTag(3, value.id);
      }
      if (!Objects.equals(value.kind, Kind.SPAN_KIND_UNSPECIFIED)) {
        result += Kind.ADAPTER.encodedSizeWithTag(4, value.kind);
      }
      if (!Objects.equals(value.name, "")) {
        result += ProtoAdapter.STRING.encodedSizeWithTag(5, value.name);
      }
      if (!Objects.equals(value.timestamp, 0L)) {
        result += ProtoAdapter.FIXED64.encodedSizeWithTag(6, value.timestamp);
      }
      if (!Objects.equals(value.duration, 0L)) {
        result += ProtoAdapter.UINT64.encodedSizeWithTag(7, value.duration);
      }
      if (!Objects.equals(value.local_endpoint, null)) {
        result += Endpoint.ADAPTER.encodedSizeWithTag(8, value.local_endpoint);
      }
      if (!Objects.equals(value.remote_endpoint, null)) {
        result += Endpoint.ADAPTER.encodedSizeWithTag(9, value.remote_endpoint);
      }
      result += Annotation.ADAPTER.asRepeated().encodedSizeWithTag(10, value.annotations);
      result += tagsAdapter().encodedSizeWithTag(11, value.tags);
      if (!Objects.equals(value.debug, false)) {
        result += ProtoAdapter.BOOL.encodedSizeWithTag(12, value.debug);
      }
      if (!Objects.equals(value.shared, false)) {
        result += ProtoAdapter.BOOL.encodedSizeWithTag(13, value.shared);
      }
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, Span value) throws IOException {
      if (!Objects.equals(value.trace_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 1, value.trace_id);
      if (!Objects.equals(value.parent_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 2, value.parent_id);
      if (!Objects.equals(value.id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 3, value.id);
      if (!Objects.equals(value.kind, Kind.SPAN_KIND_UNSPECIFIED)) Kind.ADAPTER.encodeWithTag(writer, 4, value.kind);
      if (!Objects.equals(value.name, "")) ProtoAdapter.STRING.encodeWithTag(writer, 5, value.name);
      if (!Objects.equals(value.timestamp, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 6, value.timestamp);
      if (!Objects.equals(value.duration, 0L)) ProtoAdapter.UINT64.encodeWithTag(writer, 7, value.duration);
      if (!Objects.equals(value.local_endpoint, null)) Endpoint.ADAPTER.encodeWithTag(writer, 8, value.local_endpoint);
      if (!Objects.equals(value.remote_endpoint, null)) Endpoint.ADAPTER.encodeWithTag(writer, 9, value.remote_endpoint);
      Annotation.ADAPTER.asRepeated().encodeWithTag(writer, 10, value.annotations);
      tagsAdapter().encodeWithTag(writer, 11, value.tags);
      if (!Objects.equals(value.debug, false)) ProtoAdapter.BOOL.encodeWithTag(writer, 12, value.debug);
      if (!Objects.equals(value.shared, false)) ProtoAdapter.BOOL.encodeWithTag(writer, 13, value.shared);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, Span value) throws IOException {
      writer.writeBytes(value.unknownFields());
      if (!Objects.equals(value.shared, false)) ProtoAdapter.BOOL.encodeWithTag(writer, 13, value.shared);
      if (!Objects.equals(value.debug, false)) ProtoAdapter.BOOL.encodeWithTag(writer, 12, value.debug);
      tagsAdapter().encodeWithTag(writer, 11, value.tags);
      Annotation.ADAPTER.asRepeated().encodeWithTag(writer, 10, value.annotations);
      if (!Objects.equals(value.remote_endpoint, null)) Endpoint.ADAPTER.encodeWithTag(writer, 9, value.remote_endpoint);
      if (!Objects.equals(value.local_endpoint, null)) Endpoint.ADAPTER.encodeWithTag(writer, 8, value.local_endpoint);
      if (!Objects.equals(value.duration, 0L)) ProtoAdapter.UINT64.encodeWithTag(writer, 7, value.duration);
      if (!Objects.equals(value.timestamp, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 6, value.timestamp);
      if (!Objects.equals(value.name, "")) ProtoAdapter.STRING.encodeWithTag(writer, 5, value.name);
      if (!Objects.equals(value.kind, Kind.SPAN_KIND_UNSPECIFIED)) Kind.ADAPTER.encodeWithTag(writer, 4, value.kind);
      if (!Objects.equals(value.id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 3, value.id);
      if (!Objects.equals(value.parent_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 2, value.parent_id);
      if (!Objects.equals(value.trace_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 1, value.trace_id);
    }

    @Override
    public Span decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.trace_id(ProtoAdapter.BYTES.decode(reader)); break;
          case 2: builder.parent_id(ProtoAdapter.BYTES.decode(reader)); break;
          case 3: builder.id(ProtoAdapter.BYTES.decode(reader)); break;
          case 4: {
            try {
              builder.kind(Kind.ADAPTER.decode(reader));
            } catch (ProtoAdapter.EnumConstantNotFoundException e) {
              builder.addUnknownField(tag, FieldEncoding.VARINT, (long) e.value);
            }
            break;
          }
          case 5: builder.name(ProtoAdapter.STRING.decode(reader)); break;
          case 6: builder.timestamp(ProtoAdapter.FIXED64.decode(reader)); break;
          case 7: builder.duration(ProtoAdapter.UINT64.decode(reader)); break;
          case 8: builder.local_endpoint(Endpoint.ADAPTER.decode(reader)); break;
          case 9: builder.remote_endpoint(Endpoint.ADAPTER.decode(reader)); break;
          case 10: builder.annotations.add(Annotation.ADAPTER.decode(reader)); break;
          case 11: builder.tags.putAll(tagsAdapter().decode(reader)); break;
          case 12: builder.debug(ProtoAdapter.BOOL.decode(reader)); break;
          case 13: builder.shared(ProtoAdapter.BOOL.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public Span redact(Span value) {
      Builder builder = value.newBuilder();
      if (builder.local_endpoint != null) builder.local_endpoint = Endpoint.ADAPTER.redact(builder.local_endpoint);
      if (builder.remote_endpoint != null) builder.remote_endpoint = Endpoint.ADAPTER.redact(builder.remote_endpoint);
      Internal.redactElements(builder.annotations, Annotation.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }

    private ProtoAdapter<Map<String, String>> tagsAdapter() {
      ProtoAdapter<Map<String, String>> result = tags;
      if (result == null) {
        result = ProtoAdapter.newMapAdapter(ProtoAdapter.STRING, ProtoAdapter.STRING);
        tags = result;
      }
      return result;
    }
  }
}
