/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.eureka;

import com.linecorp.armeria.common.auth.BasicToken;
import com.linecorp.armeria.server.eureka.EurekaUpdatingListener;
import com.linecorp.armeria.server.eureka.EurekaUpdatingListenerBuilder;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="zipkin.discovery.eureka")
class ZipkinEurekaDiscoveryProperties
implements Serializable {
    private URI serviceUrl;
    private String appName;
    private String instanceId;
    private String hostname;
    private BasicToken auth;

    ZipkinEurekaDiscoveryProperties() {
    }

    public URI getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(URI serviceUrl) {
        String[] ui;
        if (serviceUrl == null || serviceUrl.toString().isEmpty()) {
            this.serviceUrl = null;
            return;
        }
        if (serviceUrl.getUserInfo() != null && (ui = serviceUrl.getUserInfo().split(":")).length == 2) {
            this.auth = BasicToken.ofBasic((String)ui[0], (String)ui[1]);
        }
        this.serviceUrl = ZipkinEurekaDiscoveryProperties.stripBaseUrl(serviceUrl);
    }

    static URI stripBaseUrl(URI serviceUrl) {
        try {
            return new URI(serviceUrl.getScheme(), null, serviceUrl.getHost(), serviceUrl.getPort(), serviceUrl.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = ZipkinEurekaDiscoveryProperties.emptyToNull(appName);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = ZipkinEurekaDiscoveryProperties.emptyToNull(instanceId);
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = ZipkinEurekaDiscoveryProperties.emptyToNull(hostname);
    }

    EurekaUpdatingListenerBuilder toBuilder() {
        EurekaUpdatingListenerBuilder result = EurekaUpdatingListener.builder((URI)this.serviceUrl).homePageUrlPath("/zipkin").healthCheckUrlPath("/health").statusPageUrlPath("/info");
        if (this.auth != null) {
            result.auth(this.auth);
        }
        if (this.appName != null) {
            result.appName(this.appName);
        }
        if (this.instanceId != null) {
            result.instanceId(this.instanceId);
        }
        if (this.hostname != null) {
            result.hostname(this.hostname);
        }
        return result;
    }

    private static String emptyToNull(String s) {
        return "".equals(s) ? null : s;
    }
}

