// Code generated by Wire protocol buffer compiler, do not edit.
// Source file: zipkin.proto
package zipkin2.proto3;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Objects;
import okio.ByteString;

/**
 * The network context of a node in the service graph.
 *
 * The next id is 5.
 */
public final class Endpoint extends Message<Endpoint, Endpoint.Builder> {
  public static final ProtoAdapter<Endpoint> ADAPTER = new ProtoAdapter_Endpoint();

  private static final long serialVersionUID = 0L;

  /**
   * Lower-case label of this node in the service graph, such as "favstar".
   * Leave absent if unknown.
   *
   * This is a primary label for trace lookup and aggregation, so it should be
   * intuitive and consistent. Many use a name from service discovery.
   */
  @WireField(
      tag = 1,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "serviceName"
  )
  public final String service_name;

  /**
   * 4 byte representation of the primary IPv4 address associated with this
   * connection. Absent if unknown.
   */
  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#BYTES",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final ByteString ipv4;

  /**
   * 16 byte representation of the primary IPv6 address associated with this
   * connection. Absent if unknown.
   *
   * Prefer using the ipv4 field for mapped addresses.
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#BYTES",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final ByteString ipv6;

  /**
   * Depending on context, this could be a listen port or the client-side of a
   * socket. Absent if unknown.
   */
  @WireField(
      tag = 4,
      adapter = "com.squareup.wire.ProtoAdapter#INT32",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final int port;

  public Endpoint(String service_name, ByteString ipv4, ByteString ipv6, int port) {
    this(service_name, ipv4, ipv6, port, ByteString.EMPTY);
  }

  public Endpoint(String service_name, ByteString ipv4, ByteString ipv6, int port,
      ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    if (service_name == null) {
      throw new IllegalArgumentException("service_name == null");
    }
    this.service_name = service_name;
    if (ipv4 == null) {
      throw new IllegalArgumentException("ipv4 == null");
    }
    this.ipv4 = ipv4;
    if (ipv6 == null) {
      throw new IllegalArgumentException("ipv6 == null");
    }
    this.ipv6 = ipv6;
    this.port = port;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.service_name = service_name;
    builder.ipv4 = ipv4;
    builder.ipv6 = ipv6;
    builder.port = port;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof Endpoint)) return false;
    Endpoint o = (Endpoint) other;
    return unknownFields().equals(o.unknownFields())
        && Internal.equals(service_name, o.service_name)
        && Internal.equals(ipv4, o.ipv4)
        && Internal.equals(ipv6, o.ipv6)
        && Internal.equals(port, o.port);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + (service_name != null ? service_name.hashCode() : 0);
      result = result * 37 + (ipv4 != null ? ipv4.hashCode() : 0);
      result = result * 37 + (ipv6 != null ? ipv6.hashCode() : 0);
      result = result * 37 + Integer.hashCode(port);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (service_name != null) builder.append(", service_name=").append(Internal.sanitize(service_name));
    if (ipv4 != null) builder.append(", ipv4=").append(ipv4);
    if (ipv6 != null) builder.append(", ipv6=").append(ipv6);
    builder.append(", port=").append(port);
    return builder.replace(0, 2, "Endpoint{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<Endpoint, Builder> {
    public String service_name;

    public ByteString ipv4;

    public ByteString ipv6;

    public int port;

    public Builder() {
      service_name = "";
      ipv4 = ByteString.EMPTY;
      ipv6 = ByteString.EMPTY;
      port = 0;
    }

    /**
     * Lower-case label of this node in the service graph, such as "favstar".
     * Leave absent if unknown.
     *
     * This is a primary label for trace lookup and aggregation, so it should be
     * intuitive and consistent. Many use a name from service discovery.
     */
    public Builder service_name(String service_name) {
      this.service_name = service_name;
      return this;
    }

    /**
     * 4 byte representation of the primary IPv4 address associated with this
     * connection. Absent if unknown.
     */
    public Builder ipv4(ByteString ipv4) {
      this.ipv4 = ipv4;
      return this;
    }

    /**
     * 16 byte representation of the primary IPv6 address associated with this
     * connection. Absent if unknown.
     *
     * Prefer using the ipv4 field for mapped addresses.
     */
    public Builder ipv6(ByteString ipv6) {
      this.ipv6 = ipv6;
      return this;
    }

    /**
     * Depending on context, this could be a listen port or the client-side of a
     * socket. Absent if unknown.
     */
    public Builder port(int port) {
      this.port = port;
      return this;
    }

    @Override
    public Endpoint build() {
      return new Endpoint(service_name, ipv4, ipv6, port, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_Endpoint extends ProtoAdapter<Endpoint> {
    public ProtoAdapter_Endpoint() {
      super(FieldEncoding.LENGTH_DELIMITED, Endpoint.class, "type.googleapis.com/zipkin.proto3.Endpoint", Syntax.PROTO_3, null, "zipkin.proto");
    }

    @Override
    public int encodedSize(Endpoint value) {
      int result = 0;
      if (!Objects.equals(value.service_name, "")) {
        result += ProtoAdapter.STRING.encodedSizeWithTag(1, value.service_name);
      }
      if (!Objects.equals(value.ipv4, ByteString.EMPTY)) {
        result += ProtoAdapter.BYTES.encodedSizeWithTag(2, value.ipv4);
      }
      if (!Objects.equals(value.ipv6, ByteString.EMPTY)) {
        result += ProtoAdapter.BYTES.encodedSizeWithTag(3, value.ipv6);
      }
      if (!Objects.equals(value.port, 0)) {
        result += ProtoAdapter.INT32.encodedSizeWithTag(4, value.port);
      }
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, Endpoint value) throws IOException {
      if (!Objects.equals(value.service_name, "")) ProtoAdapter.STRING.encodeWithTag(writer, 1, value.service_name);
      if (!Objects.equals(value.ipv4, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 2, value.ipv4);
      if (!Objects.equals(value.ipv6, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 3, value.ipv6);
      if (!Objects.equals(value.port, 0)) ProtoAdapter.INT32.encodeWithTag(writer, 4, value.port);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, Endpoint value) throws IOException {
      writer.writeBytes(value.unknownFields());
      if (!Objects.equals(value.port, 0)) ProtoAdapter.INT32.encodeWithTag(writer, 4, value.port);
      if (!Objects.equals(value.ipv6, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 3, value.ipv6);
      if (!Objects.equals(value.ipv4, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 2, value.ipv4);
      if (!Objects.equals(value.service_name, "")) ProtoAdapter.STRING.encodeWithTag(writer, 1, value.service_name);
    }

    @Override
    public Endpoint decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.service_name(ProtoAdapter.STRING.decode(reader)); break;
          case 2: builder.ipv4(ProtoAdapter.BYTES.decode(reader)); break;
          case 3: builder.ipv6(ProtoAdapter.BYTES.decode(reader)); break;
          case 4: builder.port(ProtoAdapter.INT32.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public Endpoint redact(Endpoint value) {
      Builder builder = value.newBuilder();
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
