/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.collector;

import zipkin2.internal.HexCodec;

public abstract class CollectorSampler {
    public static final CollectorSampler ALWAYS_SAMPLE = CollectorSampler.create(1.0f);

    public static CollectorSampler create(float rate) {
        if (rate < 0.0f || rate > 1.0f) {
            throw new IllegalArgumentException("rate should be between 0 and 1: was " + rate);
        }
        final long boundary = (long)(9.223372E18f * rate);
        return new CollectorSampler(){

            @Override
            protected long boundary() {
                return boundary;
            }
        };
    }

    protected abstract long boundary();

    public boolean isSampled(String hexTraceId, boolean debug) {
        if (Boolean.TRUE.equals(debug)) {
            return true;
        }
        long traceId = HexCodec.lowerHexToUnsignedLong((String)hexTraceId);
        long t = traceId == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(traceId);
        return t <= this.boundary();
    }

    public String toString() {
        return "CollectorSampler(" + this.boundary() + ")";
    }

    protected CollectorSampler() {
    }
}

