/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.collector;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.Span;
import zipkin2.SpanBytesDecoderDetector;
import zipkin2.codec.BytesDecoder;
import zipkin2.codec.SpanBytesDecoder;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.CollectorSampler;
import zipkin2.storage.StorageComponent;

public class Collector {
    static final Callback<Void> NOOP_CALLBACK = new Callback<Void>(){

        public void onSuccess(Void value) {
        }

        public void onError(Throwable t) {
        }
    };
    final Logger logger;
    final CollectorMetrics metrics;
    final CollectorSampler sampler;
    final StorageComponent storage;

    public static Builder newBuilder(Class<?> loggingClass) {
        if (loggingClass == null) {
            throw new NullPointerException("loggingClass == null");
        }
        return new Builder(LoggerFactory.getLogger((String)loggingClass.getName()));
    }

    Collector(Builder builder) {
        if (builder.logger == null) {
            throw new NullPointerException("logger == null");
        }
        this.logger = builder.logger;
        CollectorMetrics collectorMetrics = this.metrics = builder.metrics == null ? CollectorMetrics.NOOP_METRICS : builder.metrics;
        if (builder.storage == null) {
            throw new NullPointerException("storage == null");
        }
        this.storage = builder.storage;
        this.sampler = builder.sampler == null ? CollectorSampler.ALWAYS_SAMPLE : builder.sampler;
    }

    public void accept(List<Span> spans, Callback<Void> callback) {
        this.accept(spans, callback, Runnable::run);
    }

    public void accept(List<Span> spans, Callback<Void> callback, Executor executor) {
        if (spans.isEmpty()) {
            callback.onSuccess(null);
            return;
        }
        this.metrics.incrementSpans(spans.size());
        List<Span> sampledSpans = this.sample(spans);
        if (sampledSpans.isEmpty()) {
            callback.onSuccess(null);
            return;
        }
        try {
            executor.execute(new StoreSpans(sampledSpans));
            callback.onSuccess(null);
        }
        catch (Throwable unexpected) {
            callback.onError(unexpected);
            throw unexpected;
        }
    }

    public void acceptSpans(ByteBuffer encoded, SpanBytesDecoder decoder, Callback<Void> callback, Executor executor) {
        List spans;
        try {
            spans = decoder.decodeList(encoded);
        }
        catch (Error | RuntimeException e) {
            this.handleDecodeError(e, callback);
            return;
        }
        this.accept(spans, callback, executor);
    }

    public void acceptSpans(byte[] serialized, Callback<Void> callback) {
        BytesDecoder decoder;
        try {
            decoder = SpanBytesDecoderDetector.decoderForListMessage((byte[])serialized);
        }
        catch (Error | RuntimeException e) {
            this.handleDecodeError(e, callback);
            return;
        }
        this.acceptSpans(serialized, (BytesDecoder<Span>)decoder, callback);
    }

    public void acceptSpans(byte[] serializedSpans, BytesDecoder<Span> decoder, Callback<Void> callback) {
        List<Span> spans;
        try {
            spans = this.decodeList(decoder, serializedSpans);
        }
        catch (Error | RuntimeException e) {
            this.handleDecodeError(e, callback);
            return;
        }
        this.accept(spans, callback);
    }

    List<Span> decodeList(BytesDecoder<Span> decoder, byte[] serialized) {
        ArrayList<Span> out = new ArrayList<Span>();
        decoder.decodeList(serialized, out);
        return out;
    }

    void store(List<Span> sampledSpans, Callback<Void> callback) {
        this.storage.spanConsumer().accept(sampledSpans).enqueue(callback);
    }

    String idString(Span span) {
        return span.traceId() + "/" + span.id();
    }

    List<Span> sample(List<Span> input) {
        ArrayList<Span> sampled = new ArrayList<Span>(input.size());
        int length = input.size();
        for (int i = 0; i < length; ++i) {
            Span s = input.get(i);
            if (!this.sampler.isSampled(s.traceId(), Boolean.TRUE.equals(s.debug()))) continue;
            sampled.add(s);
        }
        int dropped = input.size() - sampled.size();
        if (dropped > 0) {
            this.metrics.incrementSpansDropped(dropped);
        }
        return sampled;
    }

    void handleDecodeError(Throwable e, Callback<Void> callback) {
        this.metrics.incrementMessagesDropped();
        this.handleError(e, "Cannot decode spans"::toString, callback);
    }

    void handleStorageError(List<Span> spans, Throwable e, Callback<Void> callback) {
        this.metrics.incrementSpansDropped(spans.size());
        this.handleError(e, () -> this.appendSpanIds(spans, new StringBuilder("Cannot store spans ")), callback);
    }

    void handleError(Throwable e, Supplier<String> defaultLogMessage, Callback<Void> callback) {
        String error;
        Call.propagateIfFatal((Throwable)e);
        callback.onError(e);
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        String string = error = e.getMessage() != null ? e.getMessage() : "";
        if (error.startsWith("Malformed") || error.startsWith("Truncated")) {
            this.logger.debug(error, e);
        } else {
            String message = String.format("%s due to %s(%s)", defaultLogMessage.get(), e.getClass().getSimpleName(), error);
            this.logger.debug(message, e);
        }
    }

    String appendSpanIds(List<Span> spans, StringBuilder message) {
        message.append("[");
        int i = 0;
        Iterator<Span> iterator = spans.iterator();
        while (iterator.hasNext() && i++ < 3) {
            message.append(this.idString(iterator.next()));
            if (!iterator.hasNext()) continue;
            message.append(", ");
        }
        if (iterator.hasNext()) {
            message.append("...");
        }
        return message.append("]").toString();
    }

    class StoreSpans
    implements Callback<Void>,
    Runnable {
        final List<Span> spans;

        StoreSpans(List<Span> spans) {
            this.spans = spans;
        }

        @Override
        public void run() {
            try {
                Collector.this.store(this.spans, this);
            }
            catch (Error | RuntimeException e) {
                this.onError(e);
            }
        }

        public void onSuccess(Void value) {
        }

        public void onError(Throwable t) {
            Collector.this.handleStorageError(this.spans, t, NOOP_CALLBACK);
        }

        public String toString() {
            return Collector.this.appendSpanIds(this.spans, new StringBuilder("StoreSpans(")) + ")";
        }
    }

    public static final class Builder {
        final Logger logger;
        StorageComponent storage;
        CollectorSampler sampler;
        CollectorMetrics metrics;

        Builder(Logger logger) {
            this.logger = logger;
        }

        public Builder storage(StorageComponent storage) {
            if (storage == null) {
                throw new NullPointerException("storage == null");
            }
            this.storage = storage;
            return this;
        }

        public Builder metrics(CollectorMetrics metrics) {
            if (metrics == null) {
                throw new NullPointerException("metrics == null");
            }
            this.metrics = metrics;
            return this;
        }

        public Builder sampler(CollectorSampler sampler) {
            if (sampler == null) {
                throw new NullPointerException("sampler == null");
            }
            this.sampler = sampler;
            return this;
        }

        public Collector build() {
            return new Collector(this);
        }
    }
}

