/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.junit;

import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import okio.Buffer;
import okio.GzipSource;
import okio.Source;
import zipkin2.Callback;
import zipkin2.codec.BytesDecoder;
import zipkin2.codec.SpanBytesDecoder;
import zipkin2.collector.Collector;
import zipkin2.collector.CollectorMetrics;
import zipkin2.storage.StorageComponent;

final class ZipkinDispatcher
extends Dispatcher {
    private final Collector consumer;
    private final CollectorMetrics metrics;
    private final MockWebServer server;

    ZipkinDispatcher(StorageComponent storage, CollectorMetrics metrics, MockWebServer server) {
        this.consumer = Collector.newBuilder(((Object)((Object)this)).getClass()).storage(storage).metrics(metrics).build();
        this.metrics = metrics;
        this.server = server;
    }

    public MockResponse dispatch(RecordedRequest request) {
        HttpUrl url = this.server.url(request.getPath());
        if (request.getMethod().equals("POST")) {
            String type = request.getHeader("Content-Type");
            if (url.encodedPath().equals("/api/v1/spans")) {
                SpanBytesDecoder decoder = type != null && type.contains("/x-thrift") ? SpanBytesDecoder.THRIFT : SpanBytesDecoder.JSON_V1;
                return this.acceptSpans(request, decoder);
            }
            if (url.encodedPath().equals("/api/v2/spans")) {
                SpanBytesDecoder decoder = type != null && type.contains("/x-protobuf") ? SpanBytesDecoder.PROTO3 : SpanBytesDecoder.JSON_V2;
                return this.acceptSpans(request, decoder);
            }
        } else {
            return new MockResponse().setResponseCode(405);
        }
        return new MockResponse().setResponseCode(404);
    }

    MockResponse acceptSpans(RecordedRequest request, SpanBytesDecoder decoder) {
        MockResponse result;
        this.metrics.incrementMessages();
        byte[] body = request.getBody().readByteArray();
        String encoding = request.getHeader("Content-Encoding");
        if (encoding != null && encoding.contains("gzip")) {
            try {
                result = new Buffer();
                GzipSource source = new GzipSource((Source)new Buffer().write(body));
                while (source.read((Buffer)result, Integer.MAX_VALUE) != -1L) {
                }
                body = result.readByteArray();
            }
            catch (IOException e) {
                this.metrics.incrementMessagesDropped();
                return new MockResponse().setResponseCode(400).setBody("Cannot gunzip spans");
            }
        }
        result = new MockResponse();
        this.consumer.acceptSpans(body, (BytesDecoder)decoder, (Callback)new Callback<Void>(){

            public void onSuccess(Void value) {
                result.setResponseCode(202);
            }

            public void onError(Throwable t) {
                String message = t.getMessage();
                result.setBody(message).setResponseCode(message.startsWith("Cannot store") ? 500 : 400);
            }
        });
        return result;
    }
}

