/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.junit;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.mockwebserver.SocketPolicy;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import zipkin2.DependencyLink;
import zipkin2.Span;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.InMemoryCollectorMetrics;
import zipkin2.internal.Nullable;
import zipkin2.junit.HttpFailure;
import zipkin2.junit.ZipkinDispatcher;
import zipkin2.storage.InMemoryStorage;
import zipkin2.storage.StorageComponent;

public final class ZipkinRule
implements TestRule {
    private final InMemoryStorage storage = InMemoryStorage.newBuilder().build();
    private final InMemoryCollectorMetrics metrics = new InMemoryCollectorMetrics();
    private final MockWebServer server = new MockWebServer();
    private final BlockingQueue<MockResponse> failureQueue = new LinkedBlockingQueue<MockResponse>();
    private final AtomicInteger receivedSpanBytes = new AtomicInteger();

    public ZipkinRule() {
        final ZipkinDispatcher successDispatch = new ZipkinDispatcher((StorageComponent)this.storage, (CollectorMetrics)this.metrics, this.server);
        Dispatcher dispatcher = new Dispatcher(){

            public MockResponse dispatch(RecordedRequest request) {
                MockResponse maybeFailure = (MockResponse)ZipkinRule.this.failureQueue.poll();
                if (maybeFailure != null) {
                    return maybeFailure;
                }
                MockResponse result = successDispatch.dispatch(request);
                if (request.getMethod().equals("POST")) {
                    ZipkinRule.this.receivedSpanBytes.addAndGet((int)request.getBodySize());
                }
                return result;
            }

            public MockResponse peek() {
                MockResponse maybeFailure = (MockResponse)ZipkinRule.this.failureQueue.peek();
                if (maybeFailure != null) {
                    return maybeFailure.clone();
                }
                return new MockResponse().setSocketPolicy(SocketPolicy.KEEP_OPEN);
            }
        };
        this.server.setDispatcher(dispatcher);
    }

    public String httpUrl() {
        return String.format("http://%s:%s", this.server.getHostName(), this.server.getPort());
    }

    public int httpRequestCount() {
        return this.server.getRequestCount();
    }

    public InMemoryCollectorMetrics collectorMetrics() {
        return this.metrics;
    }

    public ZipkinRule storeSpans(List<Span> spans) {
        try {
            this.storage.accept(spans).execute();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    public ZipkinRule enqueueFailure(HttpFailure failure) {
        this.failureQueue.add(failure.response);
        return this;
    }

    public List<List<Span>> getTraces() {
        return this.storage.spanStore().getTraces();
    }

    @Nullable
    public List<Span> getTrace(String traceId) {
        List result;
        try {
            result = (List)this.storage.traces().getTrace(traceId).execute();
        }
        catch (IOException e) {
            throw new AssertionError("I/O exception in in-memory storage", e);
        }
        return result.isEmpty() ? null : result;
    }

    public List<DependencyLink> getDependencies() {
        return this.storage.spanStore().getDependencies();
    }

    public void start(int httpPort) throws IOException {
        this.server.start(httpPort);
    }

    public void shutdown() throws IOException {
        this.server.shutdown();
    }

    public Statement apply(Statement base, Description description) {
        return this.server.apply(base, description);
    }
}

