/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal;

import com.squareup.moshi.JsonReader;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public final class JsonReaders {
    @Nullable
    public static JsonReader enterPath(JsonReader reader, String path1, String path2) throws IOException {
        return JsonReaders.enterPath(reader, path1) != null ? JsonReaders.enterPath(reader, path2) : null;
    }

    @Nullable
    public static JsonReader enterPath(JsonReader reader, String path) throws IOException {
        try {
            if (reader.peek() != JsonReader.Token.BEGIN_OBJECT) {
                return null;
            }
        }
        catch (EOFException e) {
            return null;
        }
        reader.beginObject();
        while (reader.hasNext()) {
            if (reader.nextName().equals(path) && reader.peek() != JsonReader.Token.NULL) {
                return reader;
            }
            reader.skipValue();
        }
        reader.endObject();
        return null;
    }

    public static List<String> collectValuesNamed(JsonReader reader, String name) throws IOException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        JsonReaders.visitObject(reader, name, result);
        return new ArrayList<String>(result);
    }

    static void visitObject(JsonReader reader, String name, Set<String> result) throws IOException {
        reader.beginObject();
        while (reader.hasNext()) {
            if (reader.nextName().equals(name)) {
                result.add(reader.nextString());
                continue;
            }
            JsonReaders.visitNextOrSkip(reader, name, result);
        }
        reader.endObject();
    }

    static void visitNextOrSkip(JsonReader reader, String name, Set<String> result) throws IOException {
        switch (reader.peek()) {
            case BEGIN_ARRAY: {
                reader.beginArray();
                while (reader.hasNext()) {
                    JsonReaders.visitObject(reader, name, result);
                }
                reader.endArray();
                break;
            }
            case BEGIN_OBJECT: {
                JsonReaders.visitObject(reader, name, result);
                break;
            }
            default: {
                reader.skipValue();
            }
        }
    }

    JsonReaders() {
    }
}

