/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.internal.HttpBulkIndexer$$Lambda$1;
import zipkin2.elasticsearch.internal.client.HttpCall;
import zipkin2.internal.JsonEscaper;

public final class HttpBulkIndexer {
    static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    final String tag;
    final HttpCall.Factory http;
    final String pipeline;
    final boolean flushOnWrites;
    final Buffer body = new Buffer();
    final Set<String> indices = new LinkedHashSet<String>();

    public HttpBulkIndexer(String tag, ElasticsearchStorage es) {
        this.tag = tag;
        this.http = es.http();
        this.pipeline = es.pipeline();
        this.flushOnWrites = es.flushOnWrites();
    }

    public void add(String index, String typeName, byte[] document, @Nullable String id) {
        this.writeIndexMetadata(index, typeName, id);
        this.writeDocument(document);
    }

    void writeIndexMetadata(String index, String typeName, @Nullable String id) {
        if (this.flushOnWrites) {
            this.indices.add(index);
        }
        this.body.writeUtf8("{\"index\":{\"_index\":\"").writeUtf8(index).writeByte(34);
        this.body.writeUtf8(",\"_type\":\"").writeUtf8(typeName).writeByte(34);
        if (id != null) {
            this.body.writeUtf8(",\"_id\":\"").writeUtf8(JsonEscaper.jsonEscape((String)id)).writeByte(34);
        }
        this.body.writeUtf8("}}\n");
    }

    void writeDocument(byte[] document) {
        this.body.write(document);
        this.body.writeByte(10);
    }

    public HttpCall<Void> newCall() {
        HttpUrl url = this.pipeline != null ? this.http.baseUrl.newBuilder("_bulk").addQueryParameter("pipeline", this.pipeline).build() : this.http.baseUrl.resolve("_bulk");
        Request request = new Request.Builder().url(url).tag((Object)this.tag).post(RequestBody.create((MediaType)APPLICATION_JSON, (ByteString)this.body.readByteString())).build();
        return this.http.newCall(request, HttpBulkIndexer$$Lambda$1.lambdaFactory$(this));
    }

    static String join(Collection<String> parts) {
        Iterator<String> iterator = parts.iterator();
        StringBuilder result = new StringBuilder(iterator.next());
        while (iterator.hasNext()) {
            result.append(',').append(iterator.next());
        }
        return result.toString();
    }

    static /* synthetic */ Void lambda$newCall$0(HttpBulkIndexer this_, BufferedSource b) throws IOException {
        String content = b.readUtf8();
        if (content.indexOf("\"errors\":true") != -1) {
            throw new IllegalStateException(content);
        }
        if (this_.indices.isEmpty()) {
            return null;
        }
        ElasticsearchStorage.flush(this_.http, HttpBulkIndexer.join(this_.indices));
        return null;
    }
}

