/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal.client;

import java.io.Closeable;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import zipkin2.Call;
import zipkin2.Callback;

public final class HttpCall<V>
extends Call<V> {
    public final okhttp3.Call call;
    public final BodyConverter<V> bodyConverter;

    HttpCall(Factory factory, Request request, BodyConverter<V> bodyConverter) {
        this(factory.ok.newCall(request), bodyConverter);
    }

    HttpCall(okhttp3.Call call, BodyConverter<V> bodyConverter) {
        this.call = call;
        this.bodyConverter = bodyConverter;
    }

    public V execute() throws IOException {
        return HttpCall.parseResponse(this.call.execute(), this.bodyConverter);
    }

    public void enqueue(Callback<V> delegate) {
        this.call.enqueue(new V2CallbackAdapter<V>(this.bodyConverter, delegate));
    }

    public void cancel() {
        this.call.cancel();
    }

    public boolean isCanceled() {
        return this.call.isCanceled();
    }

    public HttpCall<V> clone() {
        return new HttpCall<V>(this.call.clone(), this.bodyConverter);
    }

    public static <V> V parseResponse(Response response, BodyConverter<V> bodyConverter) throws IOException {
        if (!HttpHeaders.hasBody((Response)response)) {
            if (response.isSuccessful()) {
                return null;
            }
            throw new IllegalStateException("response failed: " + response);
        }
        Throwable throwable = null;
        try (ResponseBody responseBody = response.body();){
            BufferedSource content = responseBody.source();
            if ("gzip".equalsIgnoreCase(response.header("Content-Encoding"))) {
                content = Okio.buffer((Source)new GzipSource((Source)responseBody.source()));
            }
            if (response.isSuccessful()) {
                V v = bodyConverter.convert(content);
                return v;
            }
            try {
                throw new IllegalStateException("response for " + response.request().tag() + " failed: " + content.readUtf8());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    static class V2CallbackAdapter<V>
    implements okhttp3.Callback {
        final BodyConverter<V> bodyConverter;
        final Callback<V> delegate;

        V2CallbackAdapter(BodyConverter<V> bodyConverter, Callback<V> delegate) {
            this.bodyConverter = bodyConverter;
            this.delegate = delegate;
        }

        public void onFailure(okhttp3.Call call, IOException e) {
            this.delegate.onError((Throwable)e);
        }

        public void onResponse(okhttp3.Call call, Response response) {
            try {
                this.delegate.onSuccess(HttpCall.parseResponse(response, this.bodyConverter));
            }
            catch (Throwable e) {
                Call.propagateIfFatal((Throwable)e);
                this.delegate.onError(e);
            }
        }
    }

    public static class Factory
    implements Closeable {
        final OkHttpClient ok;
        public final HttpUrl baseUrl;

        public Factory(OkHttpClient ok, HttpUrl baseUrl) {
            this.ok = ok;
            this.baseUrl = baseUrl;
        }

        public <V> HttpCall<V> newCall(Request request, BodyConverter<V> bodyConverter) {
            return new HttpCall<V>(this, request, bodyConverter);
        }

        @Override
        public void close() {
            this.ok.dispatcher().executorService().shutdownNow();
        }
    }

    public static interface BodyConverter<V> {
        public V convert(BufferedSource var1) throws IOException;
    }
}

