/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal;

import com.google.auto.value.AutoValue;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import zipkin2.elasticsearch.internal.AutoValue_IndexNameFormatter;
import zipkin2.internal.Nullable;

@AutoValue
public abstract class IndexNameFormatter {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    public static Builder newBuilder() {
        return new AutoValue_IndexNameFormatter.Builder();
    }

    public abstract Builder toBuilder();

    public abstract String index();

    abstract char dateSeparator();

    abstract ThreadLocal<SimpleDateFormat> dateFormat();

    public List<String> formatTypeAndRange(@Nullable String type, long beginMillis, long endMillis) {
        GregorianCalendar end;
        GregorianCalendar current = IndexNameFormatter.midnightUTC(beginMillis);
        if (current.equals(end = IndexNameFormatter.midnightUTC(endMillis))) {
            return Collections.singletonList(this.formatTypeAndTimestamp(type, current.getTimeInMillis()));
        }
        String prefix = this.prefix(type);
        ArrayList<String> indices = new ArrayList<String>();
        while (current.compareTo(end) <= 0) {
            if (current.get(2) == 0 && current.get(5) == 1) {
                current.set(6, current.getActualMaximum(6));
                if (current.compareTo(end) <= 0) {
                    indices.add(String.format("%s-%s%c*", prefix, current.get(1), Character.valueOf(this.dateSeparator())));
                    current.add(5, 1);
                    continue;
                }
                current.set(6, 1);
            } else if (current.get(5) == 1) {
                current.set(5, current.getActualMaximum(5));
                if (current.compareTo(end) <= 0) {
                    indices.add(String.format("%s-%s%c%02d%c*", prefix, current.get(1), Character.valueOf(this.dateSeparator()), current.get(2) + 1, Character.valueOf(this.dateSeparator())));
                    current.add(5, 1);
                    continue;
                }
                current.set(5, 1);
            }
            indices.add(this.formatTypeAndTimestamp(type, current.getTimeInMillis()));
            current.add(5, 1);
        }
        return indices;
    }

    static GregorianCalendar midnightUTC(long epochMillis) {
        GregorianCalendar result = new GregorianCalendar(UTC);
        Calendar day = Calendar.getInstance(UTC);
        day.setTimeInMillis(epochMillis);
        day.set(14, 0);
        day.set(13, 0);
        day.set(12, 0);
        day.set(11, 0);
        result.setTimeInMillis(day.getTimeInMillis());
        return result;
    }

    public String formatTypeAndTimestamp(@Nullable String type, long timestampMillis) {
        return this.prefix(type) + "-" + this.dateFormat().get().format(new Date(timestampMillis));
    }

    private String prefix(@Nullable String type) {
        return type != null ? this.index() + ":" + type : this.index();
    }

    public long parseDate(String timestamp) {
        try {
            return this.dateFormat().get().parse(timestamp).getTime();
        }
        catch (ParseException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String formatType(@Nullable String type) {
        return this.prefix(type) + "-*";
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder index(String var1);

        public abstract Builder dateSeparator(char var1);

        abstract Builder dateFormat(ThreadLocal<SimpleDateFormat> var1);

        abstract char dateSeparator();

        public final IndexNameFormatter build() {
            return this.dateFormat(new ThreadLocal<SimpleDateFormat>(){

                @Override
                protected SimpleDateFormat initialValue() {
                    char separator = this.dateSeparator();
                    SimpleDateFormat result = new SimpleDateFormat(separator == '\u0000' ? "yyyyMMdd" : "yyyy-MM-dd".replace('-', separator));
                    result.setTimeZone(UTC);
                    return result;
                }
            }).autoBuild();
        }

        abstract IndexNameFormatter autoBuild();
    }
}

