/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal.client;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class Aggregation {
    final transient String field;
    AggTerms terms;
    Map<String, String> min;
    Map<String, Aggregation> aggs;

    Aggregation(String field) {
        this.field = field;
    }

    public static Aggregation terms(String field, int size) {
        Aggregation result = new Aggregation(field);
        result.terms = new AggTerms(field, size);
        return result;
    }

    public Aggregation orderBy(String subAgg, String direction) {
        this.terms.order(subAgg, direction);
        return this;
    }

    public static Aggregation min(String field) {
        Aggregation result = new Aggregation(field);
        result.min = Collections.singletonMap("field", field);
        return result;
    }

    public Aggregation addSubAggregation(Aggregation agg) {
        if (this.aggs == null) {
            this.aggs = new LinkedHashMap<String, Aggregation>();
        }
        this.aggs.put(agg.field, agg);
        return this;
    }

    static class AggTerms {
        final String field;
        int size;
        Map<String, String> order;

        AggTerms(String field, int size) {
            this.field = field;
            this.size = size;
        }

        AggTerms order(String agg, String direction) {
            this.order = Collections.singletonMap(agg, direction);
            return this;
        }
    }
}

