

package zipkin2.elasticsearch;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_IndexTemplates extends IndexTemplates {

  private final float version;

  private final String span;

  private final String dependency;

  private AutoValue_IndexTemplates(
      float version,
      String span,
      String dependency) {
    this.version = version;
    this.span = span;
    this.dependency = dependency;
  }

  @Override
  float version() {
    return version;
  }

  @Override
  String span() {
    return span;
  }

  @Override
  String dependency() {
    return dependency;
  }

  @Override
  public String toString() {
    return "IndexTemplates{"
         + "version=" + version + ", "
         + "span=" + span + ", "
         + "dependency=" + dependency
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof IndexTemplates) {
      IndexTemplates that = (IndexTemplates) o;
      return (Float.floatToIntBits(this.version) == Float.floatToIntBits(that.version()))
           && (this.span.equals(that.span()))
           && (this.dependency.equals(that.dependency()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= Float.floatToIntBits(version);
    h$ *= 1000003;
    h$ ^= span.hashCode();
    h$ *= 1000003;
    h$ ^= dependency.hashCode();
    return h$;
  }

  static final class Builder implements IndexTemplates.Builder {
    private Float version;
    private String span;
    private String dependency;
    Builder() {
    }
    @Override
    public IndexTemplates.Builder version(float version) {
      this.version = version;
      return this;
    }
    @Override
    public IndexTemplates.Builder span(String span) {
      if (span == null) {
        throw new NullPointerException("Null span");
      }
      this.span = span;
      return this;
    }
    @Override
    public IndexTemplates.Builder dependency(String dependency) {
      if (dependency == null) {
        throw new NullPointerException("Null dependency");
      }
      this.dependency = dependency;
      return this;
    }
    @Override
    public IndexTemplates build() {
      String missing = "";
      if (this.version == null) {
        missing += " version";
      }
      if (this.span == null) {
        missing += " span";
      }
      if (this.dependency == null) {
        missing += " dependency";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_IndexTemplates(
          this.version,
          this.span,
          this.dependency);
    }
  }

}
