/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch;

import com.squareup.moshi.JsonReader;
import java.io.IOException;
import java.util.logging.Logger;
import okhttp3.Request;
import okio.BufferedSource;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.IndexTemplates;
import zipkin2.elasticsearch.internal.JsonReaders;
import zipkin2.elasticsearch.internal.client.HttpCall;

final class VersionSpecificTemplates {
    static final Logger LOG = Logger.getLogger(VersionSpecificTemplates.class.getName());
    final boolean searchEnabled;
    final String spanIndexTemplate;
    final String dependencyIndexTemplate;
    final String autocompleteIndexTemplate;
    static final String DEPENDENCY_INDEX_TEMPLATE = "{\n  \"TEMPLATE\": \"${__INDEX__}:dependency-*\",\n  \"settings\": {\n    \"index.number_of_shards\": ${__NUMBER_OF_SHARDS__},\n    \"index.number_of_replicas\": ${__NUMBER_OF_REPLICAS__},\n    \"index.requests.cache.enable\": true,\n    \"index.mapper.dynamic\": false\n  },\n  \"mappings\": {\"dependency\": { \"enabled\": false }}\n}";
    static final String AUTOCOMPLETE_INDEX_TEMPLATE = "{\n  \"TEMPLATE\": \"${__INDEX__}:autocomplete-*\",\n  \"settings\": {\n    \"index.number_of_shards\": ${__NUMBER_OF_SHARDS__},\n    \"index.number_of_replicas\": ${__NUMBER_OF_REPLICAS__},\n    \"index.requests.cache.enable\": true,\n    \"index.mapper.dynamic\": true\n  },\n  \"mappings\": {\"autocomplete\": { \"enabled\": true,\n \t\"properties\": {\n        \"tagKey\": { KEYWORD },\n        \"tagValue\": { KEYWORD }\n  }}}\n}";

    VersionSpecificTemplates(ElasticsearchStorage es) {
        this.searchEnabled = es.searchEnabled();
        this.spanIndexTemplate = this.spanIndexTemplate().replace("${__INDEX__}", es.indexNameFormatter().index()).replace("${__NUMBER_OF_SHARDS__}", String.valueOf(es.indexShards())).replace("${__NUMBER_OF_REPLICAS__}", String.valueOf(es.indexReplicas())).replace("${__TRACE_ID_MAPPING__}", es.strictTraceId() ? "{ KEYWORD }" : "{ \"type\": \"STRING\", \"analyzer\": \"traceId_analyzer\" }");
        this.dependencyIndexTemplate = DEPENDENCY_INDEX_TEMPLATE.replace("${__INDEX__}", es.indexNameFormatter().index()).replace("${__NUMBER_OF_SHARDS__}", String.valueOf(es.indexShards())).replace("${__NUMBER_OF_REPLICAS__}", String.valueOf(es.indexReplicas()));
        this.autocompleteIndexTemplate = AUTOCOMPLETE_INDEX_TEMPLATE.replace("${__INDEX__}", es.indexNameFormatter().index()).replace("${__NUMBER_OF_SHARDS__}", String.valueOf(es.indexShards())).replace("${__NUMBER_OF_REPLICAS__}", String.valueOf(es.indexReplicas()));
    }

    String spanIndexTemplate() {
        String result = "{\n  \"TEMPLATE\": \"${__INDEX__}:span-*\",\n  \"settings\": {\n    \"index.number_of_shards\": ${__NUMBER_OF_SHARDS__},\n    \"index.number_of_replicas\": ${__NUMBER_OF_REPLICAS__},\n    \"index.requests.cache.enable\": true,\n    \"index.mapper.dynamic\": false,\n    \"analysis\": {\n      \"analyzer\": {\n        \"traceId_analyzer\": {\n          \"type\": \"custom\",\n          \"tokenizer\": \"keyword\",\n          \"filter\": \"traceId_filter\"\n        }\n      },\n      \"filter\": {\n        \"traceId_filter\": {\n          \"type\": \"pattern_capture\",\n          \"patterns\": [\"([0-9a-f]{1,16})$\"],\n          \"preserve_original\": true\n        }\n      }\n    }\n  },\n";
        if (this.searchEnabled) {
            return result + "  \"mappings\": {\n    \"_default_\": {\n      DISABLE_ALL      \"dynamic_templates\": [\n        {\n          \"strings\": {\n            \"mapping\": {\n              KEYWORD,\n              \"ignore_above\": 256\n            },\n            \"match_mapping_type\": \"string\",\n            \"match\": \"*\"\n          }\n        }\n      ]\n    },\n    \"span\": {\n      \"_source\": {\"excludes\": [\"_q\"] },\n      \"properties\": {\n        \"traceId\": ${__TRACE_ID_MAPPING__},\n        \"name\": { KEYWORD },\n        \"localEndpoint\": {\n          \"type\": \"object\",\n          \"dynamic\": false,\n          \"properties\": { \"serviceName\": { KEYWORD } }\n        },\n        \"remoteEndpoint\": {\n          \"type\": \"object\",\n          \"dynamic\": false,\n          \"properties\": { \"serviceName\": { KEYWORD } }\n        },\n        \"timestamp_millis\": {\n          \"type\":   \"date\",\n          \"format\": \"epoch_millis\"\n        },\n        \"duration\": { \"type\": \"long\" },\n        \"annotations\": { \"enabled\": false },\n        \"tags\": { \"enabled\": false },\n        \"_q\": { KEYWORD }\n      }\n    }\n  }\n}";
        }
        return result + "  \"mappings\": {\n    \"_default_\": { DISABLE_ALL },\n    \"span\": {\n      \"properties\": {\n        \"traceId\": ${__TRACE_ID_MAPPING__},\n        \"annotations\": { \"enabled\": false },\n        \"tags\": { \"enabled\": false }\n      }\n    }\n  }\n}";
    }

    IndexTemplates get(HttpCall.Factory callFactory) throws IOException {
        float version = VersionSpecificTemplates.getVersion(callFactory);
        return IndexTemplates.newBuilder().version(version).span(this.versionSpecificSpanIndexTemplate(version)).dependency(this.versionSpecificDependencyLinkIndexTemplate(version)).autocomplete(this.versionSpecificAutocompleteIndexTemplate(version)).build();
    }

    static float getVersion(HttpCall.Factory callFactory) throws IOException {
        Request getNode = new Request.Builder().url(callFactory.baseUrl).tag((Object)"get-node").build();
        return callFactory.newCall(getNode, ReadVersionNumber.INSTANCE).execute().floatValue();
    }

    private String versionSpecificSpanIndexTemplate(float version) {
        if (version >= 2.0f && version < 3.0f) {
            return this.spanIndexTemplate.replace("TEMPLATE", "template").replace("STRING", "string").replace("DISABLE_ALL", "\"_all\": {\"enabled\": false}" + (this.searchEnabled ? ",\n" : "")).replace("KEYWORD", "\"type\": \"string\", \"norms\": {\"enabled\": false }, \"index\": \"not_analyzed\"");
        }
        if (version >= 5.0f) {
            return this.spanIndexTemplate.replace("TEMPLATE", version >= 6.0f ? "index_patterns" : "template").replace("STRING", "text").replace("DISABLE_ALL", "").replace("KEYWORD", "\"type\": \"keyword\", \"norms\": false").replace("\"analyzer\": \"traceId_analyzer\" }", "\"fielddata\": \"true\", \"analyzer\": \"traceId_analyzer\" }");
        }
        throw new IllegalStateException("Elasticsearch 2.x, 5.x and 6.x are supported, was: " + version);
    }

    private String versionSpecificDependencyLinkIndexTemplate(float version) {
        return this.dependencyIndexTemplate.replace("TEMPLATE", version >= 6.0f ? "index_patterns" : "template");
    }

    private String versionSpecificAutocompleteIndexTemplate(float version) {
        if (version >= 2.0f && version < 3.0f) {
            return this.autocompleteIndexTemplate.replace("TEMPLATE", "template").replace("KEYWORD", "\"type\": \"string\", \"norms\": {\"enabled\": false }, \"index\": \"not_analyzed\"");
        }
        if (version >= 5.0f) {
            return this.autocompleteIndexTemplate.replace("TEMPLATE", version >= 6.0f ? "index_patterns" : "template").replace("KEYWORD", "\"type\": \"keyword\",\"norms\": false\n");
        }
        throw new IllegalStateException("Elasticsearch 2.x, 5.x and 6.x are supported, was: " + version);
    }

    static enum ReadVersionNumber implements HttpCall.BodyConverter<Float>
    {
        INSTANCE;


        @Override
        public Float convert(BufferedSource content) throws IOException {
            JsonReader version = JsonReaders.enterPath(JsonReader.of((BufferedSource)content), "version", "number");
            if (version == null) {
                throw new IllegalStateException(".version.number not in response");
            }
            String versionString = version.nextString();
            float result = Float.valueOf(versionString.substring(0, 3)).floatValue();
            if (result < 2.0f) {
                LOG.warning("Please upgrade to Elasticsearch 2 or later. version=" + versionString);
            }
            return Float.valueOf(result);
        }

        public String toString() {
            return "GetVersion";
        }
    }
}

