/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal.client;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okio.BufferedSource;
import zipkin2.elasticsearch.internal.JsonReaders;
import zipkin2.elasticsearch.internal.client.HttpCall;

public class SearchResultConverter<T>
implements HttpCall.BodyConverter<List<T>> {
    final JsonAdapter<T> adapter;
    final List<T> defaultValue;

    public static <T> SearchResultConverter<T> create(JsonAdapter<T> adapter) {
        return new SearchResultConverter<T>(adapter);
    }

    protected SearchResultConverter(JsonAdapter<T> adapter) {
        this.adapter = adapter;
        this.defaultValue = Collections.emptyList();
    }

    @Override
    public List<T> convert(BufferedSource content) throws IOException {
        JsonReader hits = JsonReaders.enterPath(JsonReader.of((BufferedSource)content), "hits", "hits");
        if (hits == null || hits.peek() != JsonReader.Token.BEGIN_ARRAY) {
            return this.defaultValue;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        hits.beginArray();
        while (hits.hasNext()) {
            JsonReader source = JsonReaders.enterPath(hits, "_source");
            if (source != null) {
                result.add(this.adapter.fromJson(source));
            }
            hits.endObject();
        }
        hits.endArray();
        return result.isEmpty() ? this.defaultValue : result;
    }
}

