/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch;

import zipkin2.elasticsearch.IndexTemplates;

final class AutoValue_IndexTemplates
extends IndexTemplates {
    private final float version;
    private final String span;
    private final String dependency;
    private final String autocomplete;

    private AutoValue_IndexTemplates(float version, String span, String dependency, String autocomplete) {
        this.version = version;
        this.span = span;
        this.dependency = dependency;
        this.autocomplete = autocomplete;
    }

    @Override
    float version() {
        return this.version;
    }

    @Override
    String span() {
        return this.span;
    }

    @Override
    String dependency() {
        return this.dependency;
    }

    @Override
    String autocomplete() {
        return this.autocomplete;
    }

    public String toString() {
        return "IndexTemplates{version=" + this.version + ", span=" + this.span + ", dependency=" + this.dependency + ", autocomplete=" + this.autocomplete + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IndexTemplates) {
            IndexTemplates that = (IndexTemplates)o;
            return Float.floatToIntBits(this.version) == Float.floatToIntBits(that.version()) && this.span.equals(that.span()) && this.dependency.equals(that.dependency()) && this.autocomplete.equals(that.autocomplete());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= Float.floatToIntBits(this.version);
        h$ *= 1000003;
        h$ ^= this.span.hashCode();
        h$ *= 1000003;
        h$ ^= this.dependency.hashCode();
        h$ *= 1000003;
        return h$ ^= this.autocomplete.hashCode();
    }

    static final class Builder
    implements IndexTemplates.Builder {
        private Float version;
        private String span;
        private String dependency;
        private String autocomplete;

        Builder() {
        }

        @Override
        public IndexTemplates.Builder version(float version) {
            this.version = Float.valueOf(version);
            return this;
        }

        @Override
        public IndexTemplates.Builder span(String span) {
            if (span == null) {
                throw new NullPointerException("Null span");
            }
            this.span = span;
            return this;
        }

        @Override
        public IndexTemplates.Builder dependency(String dependency) {
            if (dependency == null) {
                throw new NullPointerException("Null dependency");
            }
            this.dependency = dependency;
            return this;
        }

        @Override
        public IndexTemplates.Builder autocomplete(String autocomplete) {
            if (autocomplete == null) {
                throw new NullPointerException("Null autocomplete");
            }
            this.autocomplete = autocomplete;
            return this;
        }

        @Override
        public IndexTemplates build() {
            String missing = "";
            if (this.version == null) {
                missing = missing + " version";
            }
            if (this.span == null) {
                missing = missing + " span";
            }
            if (this.dependency == null) {
                missing = missing + " dependency";
            }
            if (this.autocomplete == null) {
                missing = missing + " autocomplete";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_IndexTemplates(this.version.floatValue(), this.span, this.dependency, this.autocomplete);
        }
    }
}

