/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch;

import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import zipkin2.Annotation;
import zipkin2.Call;
import zipkin2.Span;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.internal.HttpBulkIndexer;
import zipkin2.elasticsearch.internal.IndexNameFormatter;
import zipkin2.elasticsearch.internal.client.HttpCall;
import zipkin2.internal.DelayLimiter;
import zipkin2.internal.JsonEscaper;
import zipkin2.storage.SpanConsumer;

class ElasticsearchSpanConsumer
implements SpanConsumer {
    static final Logger LOG = Logger.getLogger(ElasticsearchSpanConsumer.class.getName());
    static final int INDEX_CHARS_LIMIT = 256;
    static final ByteString EMPTY_JSON = ByteString.of((byte[])new byte[]{123, 125});
    final ElasticsearchStorage es;
    final Set<String> autocompleteKeys;
    final IndexNameFormatter indexNameFormatter;
    final boolean searchEnabled;
    final DelayLimiter<AutocompleteContext> delayLimiter;

    ElasticsearchSpanConsumer(ElasticsearchStorage es) {
        this.es = es;
        this.autocompleteKeys = new LinkedHashSet<String>(es.autocompleteKeys());
        this.indexNameFormatter = es.indexNameFormatter();
        this.searchEnabled = es.searchEnabled();
        this.delayLimiter = DelayLimiter.newBuilder().ttl(es.autocompleteTtl()).cardinality(es.autocompleteCardinality()).build();
    }

    public Call<Void> accept(List<Span> spans) {
        if (spans.isEmpty()) {
            return Call.create(null);
        }
        BulkSpanIndexer indexer = new BulkSpanIndexer(this);
        this.indexSpans(indexer, spans);
        return indexer.newCall();
    }

    void indexSpans(BulkSpanIndexer indexer, List<Span> spans) {
        for (Span span : spans) {
            long spanTimestamp = span.timestampAsLong();
            long indexTimestamp = 0L;
            if (spanTimestamp != 0L) {
                indexTimestamp = spanTimestamp = TimeUnit.MICROSECONDS.toMillis(spanTimestamp);
            } else {
                int i = 0;
                int length = span.annotations().size();
                if (i < length) {
                    indexTimestamp = ((Annotation)span.annotations().get(i)).timestamp() / 1000L;
                }
                if (indexTimestamp == 0L) {
                    indexTimestamp = System.currentTimeMillis();
                }
            }
            indexer.add(indexTimestamp, span, spanTimestamp);
            if (!this.searchEnabled || span.tags().isEmpty()) continue;
            indexer.addAutocompleteValues(indexTimestamp, span);
        }
    }

    static byte[] prefixWithTimestampMillisAndQuery(Span span, long timestampMillis) {
        Buffer prefix = new Buffer();
        JsonWriter writer = JsonWriter.of((BufferedSink)prefix);
        try {
            writer.beginObject();
            if (timestampMillis != 0L) {
                writer.name("timestamp_millis").value(timestampMillis);
            }
            if (!span.tags().isEmpty() || !span.annotations().isEmpty()) {
                writer.name("_q");
                writer.beginArray();
                for (Annotation annotation : span.annotations()) {
                    if (annotation.value().length() > 256) continue;
                    writer.value(annotation.value());
                }
                for (Map.Entry entry : span.tags().entrySet()) {
                    int length = ((String)entry.getKey()).length() + ((String)entry.getValue()).length() + 1;
                    if (length > 256) continue;
                    writer.value((String)entry.getKey());
                    writer.value((String)entry.getKey() + "=" + (String)entry.getValue());
                }
                writer.endArray();
            }
            writer.endObject();
        }
        catch (IOException e) {
            assert (false) : "Error indexing query for span: " + span;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Error indexing query for span: " + span, e);
            }
            return SpanBytesEncoder.JSON_V2.encode((Object)span);
        }
        byte[] document = SpanBytesEncoder.JSON_V2.encode((Object)span);
        if (prefix.rangeEquals(0L, EMPTY_JSON)) {
            return document;
        }
        return ElasticsearchSpanConsumer.mergeJson(prefix.readByteArray(), document);
    }

    static byte[] mergeJson(byte[] prefix, byte[] suffix) {
        byte[] newSpanBytes = new byte[prefix.length + suffix.length - 1];
        int pos = 0;
        System.arraycopy(prefix, 0, newSpanBytes, pos, prefix.length);
        newSpanBytes[(pos += prefix.length) - 1] = 44;
        System.arraycopy(suffix, 1, newSpanBytes, pos, suffix.length - 1);
        return newSpanBytes;
    }

    static final class AutocompleteContext {
        final long indexTimestamp;
        final String autocompleteId;

        AutocompleteContext(long indexTimestamp, String autocompleteId) {
            this.indexTimestamp = indexTimestamp;
            this.autocompleteId = autocompleteId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AutocompleteContext)) {
                return false;
            }
            AutocompleteContext that = (AutocompleteContext)o;
            return this.indexTimestamp == that.indexTimestamp && this.autocompleteId.equals(that.autocompleteId);
        }

        public int hashCode() {
            int h$ = 1;
            h$ *= 1000003;
            h$ ^= (int)((long)h$ ^ (this.indexTimestamp >>> 32 ^ this.indexTimestamp));
            h$ *= 1000003;
            return h$ ^= this.autocompleteId.hashCode();
        }
    }

    static final class BulkSpanIndexer {
        final HttpBulkIndexer indexer;
        final ElasticsearchSpanConsumer consumer;
        final List<AutocompleteContext> pendingAutocompleteContexts = new ArrayList<AutocompleteContext>();

        BulkSpanIndexer(ElasticsearchSpanConsumer consumer) {
            this.indexer = new HttpBulkIndexer("index-span", consumer.es);
            this.consumer = consumer;
        }

        void add(long indexTimestamp, Span span, long timestampMillis) {
            String index = this.consumer.indexNameFormatter.formatTypeAndTimestamp("span", indexTimestamp);
            byte[] document = this.consumer.searchEnabled ? ElasticsearchSpanConsumer.prefixWithTimestampMillisAndQuery(span, timestampMillis) : SpanBytesEncoder.JSON_V2.encode((Object)span);
            this.indexer.add(index, "span", document, null);
        }

        void addAutocompleteValues(long indexTimestamp, Span span) {
            String idx = this.consumer.indexNameFormatter.formatTypeAndTimestamp("autocomplete", indexTimestamp);
            for (Map.Entry tag : span.tags().entrySet()) {
                String id;
                AutocompleteContext context;
                int length = ((String)tag.getKey()).length() + ((String)tag.getValue()).length() + 1;
                if (length > 256 || !this.consumer.autocompleteKeys.contains(tag.getKey()) || !this.consumer.delayLimiter.shouldInvoke((Object)(context = new AutocompleteContext(indexTimestamp, id = (String)tag.getKey() + "=" + (String)tag.getValue())))) continue;
                this.pendingAutocompleteContexts.add(context);
                int sizeInBytes = 27;
                sizeInBytes += JsonEscaper.jsonEscapedSizeInBytes((CharSequence)((CharSequence)tag.getKey()));
                zipkin2.internal.Buffer b = zipkin2.internal.Buffer.allocate((int)(sizeInBytes += JsonEscaper.jsonEscapedSizeInBytes((CharSequence)((CharSequence)tag.getValue()))));
                b.writeAscii("{\"tagKey\":\"");
                b.writeUtf8(JsonEscaper.jsonEscape((CharSequence)((CharSequence)tag.getKey())));
                b.writeAscii("\",\"tagValue\":\"");
                b.writeUtf8(JsonEscaper.jsonEscape((CharSequence)((CharSequence)tag.getValue())));
                b.writeAscii("\"}");
                byte[] document = b.toByteArray();
                this.indexer.add(idx, "autocomplete", document, id);
            }
        }

        Call<Void> newCall() {
            HttpCall<Void> storeCall = this.indexer.newCall();
            if (this.pendingAutocompleteContexts.isEmpty()) {
                return storeCall;
            }
            return storeCall.handleError((error, callback) -> {
                for (AutocompleteContext context : this.pendingAutocompleteContexts) {
                    this.consumer.delayLimiter.invalidate((Object)context);
                }
                callback.onError(error);
            });
        }
    }
}

