/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch;

import com.squareup.moshi.JsonReader;
import java.io.IOException;
import okhttp3.Request;
import okio.BufferedSource;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.IndexTemplates;
import zipkin2.elasticsearch.internal.JsonReaders;
import zipkin2.elasticsearch.internal.client.HttpCall;

final class VersionSpecificTemplates {
    static final String KEYWORD = "{ \"type\": \"keyword\", \"norms\": false }";
    final ElasticsearchStorage es;

    VersionSpecificTemplates(ElasticsearchStorage es) {
        this.es = es;
    }

    String indexPattern(String type, float version) {
        return '\"' + (version < 6.0f ? "template" : "index_patterns") + "\": \"" + this.es.indexNameFormatter().index() + VersionSpecificTemplates.indexTypeDelimiter(version) + type + "-*" + "\"";
    }

    String indexProperties(float version) {
        String result = "    \"index.number_of_shards\": " + this.es.indexShards() + ",\n    \"index.number_of_replicas\": " + this.es.indexReplicas() + ",\n    \"index.requests.cache.enable\": true";
        if (version >= 7.0f) {
            return result + "\n";
        }
        return result + ",\n    \"index.mapper.dynamic\": false\n";
    }

    String spanIndexTemplate(float version) {
        String result = "{\n  " + this.indexPattern("span", version) + ",\n  \"settings\": {\n" + this.indexProperties(version);
        String traceIdMapping = KEYWORD;
        if (!this.es.strictTraceId()) {
            traceIdMapping = "{ \"type\": \"text\", \"fielddata\": \"true\", \"analyzer\": \"traceId_analyzer\" }";
            result = result + ",\n    \"analysis\": {\n      \"analyzer\": {\n        \"traceId_analyzer\": {\n          \"type\": \"custom\",\n          \"tokenizer\": \"keyword\",\n          \"filter\": \"traceId_filter\"\n        }\n      },\n      \"filter\": {\n        \"traceId_filter\": {\n          \"type\": \"pattern_capture\",\n          \"patterns\": [\"([0-9a-f]{1,16})$\"],\n          \"preserve_original\": true\n        }\n      }\n    }\n";
        }
        result = result + "  },\n";
        if (this.es.searchEnabled()) {
            return result + "  \"mappings\": {\n" + VersionSpecificTemplates.maybeWrap("span", version, "    \"_source\": {\"excludes\": [\"_q\"] },\n    \"dynamic_templates\": [\n      {\n        \"strings\": {\n          \"mapping\": {\n            \"type\": \"keyword\",\"norms\": false, \"ignore_above\": 256\n          },\n          \"match_mapping_type\": \"string\",\n          \"match\": \"*\"\n        }\n      }\n    ],\n    \"properties\": {\n      \"traceId\": " + traceIdMapping + ",\n      \"name\": " + KEYWORD + ",\n      \"localEndpoint\": {\n        \"type\": \"object\",\n        \"dynamic\": false,\n        \"properties\": { \"serviceName\": " + KEYWORD + " }\n      },\n      \"remoteEndpoint\": {\n        \"type\": \"object\",\n        \"dynamic\": false,\n        \"properties\": { \"serviceName\": " + KEYWORD + " }\n      },\n      \"timestamp_millis\": {\n        \"type\":   \"date\",\n        \"format\": \"epoch_millis\"\n      },\n      \"duration\": { \"type\": \"long\" },\n      \"annotations\": { \"enabled\": false },\n      \"tags\": { \"enabled\": false },\n      \"_q\": " + KEYWORD + "\n    }\n") + "  }\n}";
        }
        return result + "  \"mappings\": {\n" + VersionSpecificTemplates.maybeWrap("span", version, "    \"properties\": {\n      \"traceId\": " + traceIdMapping + ",\n      \"annotations\": { \"enabled\": false },\n      \"tags\": { \"enabled\": false }\n    }\n") + "  }\n}";
    }

    String dependencyTemplate(float version) {
        return "{\n  " + this.indexPattern("dependency", version) + ",\n  \"settings\": {\n" + this.indexProperties(version) + "  },\n  \"mappings\": {\n" + VersionSpecificTemplates.maybeWrap("dependency", version, "    \"enabled\": false\n") + "  }\n}";
    }

    String autocompleteTemplate(float version) {
        return "{\n  " + this.indexPattern("autocomplete", version) + ",\n  \"settings\": {\n" + this.indexProperties(version) + "  },\n  \"mappings\": {\n" + VersionSpecificTemplates.maybeWrap("autocomplete", version, "    \"enabled\": true,\n    \"properties\": {\n      \"tagKey\": { \"type\": \"keyword\", \"norms\": false },\n      \"tagValue\": { \"type\": \"keyword\", \"norms\": false }\n    }\n") + "  }\n}";
    }

    IndexTemplates get() throws IOException {
        float version = VersionSpecificTemplates.getVersion(this.es.http());
        if (version < 5.0f || version >= 8.0f) {
            throw new IllegalArgumentException("Elasticsearch versions 5-7.x are supported, was: " + version);
        }
        return IndexTemplates.newBuilder().version(version).indexTypeDelimiter(VersionSpecificTemplates.indexTypeDelimiter(version)).span(this.spanIndexTemplate(version)).dependency(this.dependencyTemplate(version)).autocomplete(this.autocompleteTemplate(version)).build();
    }

    static char indexTypeDelimiter(float version) {
        return version < 7.0f ? (char)':' : '-';
    }

    static String maybeWrap(String type, float version, String json) {
        if (version >= 7.0f) {
            return json;
        }
        return "    \"" + type + "\": {\n  " + json.replace("\n", "\n  ") + "  }\n";
    }

    static float getVersion(HttpCall.Factory callFactory) throws IOException {
        Request getNode = new Request.Builder().url(callFactory.baseUrl).tag((Object)"get-node").build();
        return ((Float)callFactory.newCall(getNode, ReadVersionNumber.INSTANCE).execute()).floatValue();
    }

    static enum ReadVersionNumber implements HttpCall.BodyConverter<Float>
    {
        INSTANCE;


        @Override
        public Float convert(BufferedSource content) throws IOException {
            JsonReader version = JsonReaders.enterPath(JsonReader.of((BufferedSource)content), "version", "number");
            if (version == null) {
                throw new IllegalStateException(".version.number not in response");
            }
            String versionString = version.nextString();
            return Float.valueOf(versionString.substring(0, 3));
        }
    }
}

