/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal;

import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSink;
import okio.HashingSink;
import okio.Okio;
import okio.Sink;
import zipkin2.Annotation;
import zipkin2.Endpoint;
import zipkin2.Span;

public abstract class BulkIndexWriter<T> {
    public static final BulkIndexWriter<Span> SPAN = new BulkIndexWriter<Span>(){

        @Override
        public String writeDocument(Span input, BufferedSink sink) {
            return 1.write(input, true, sink);
        }
    };
    public static final BulkIndexWriter<Span> SPAN_SEARCH_DISABLED = new BulkIndexWriter<Span>(){

        @Override
        public String writeDocument(Span input, BufferedSink sink) {
            return 2.write(input, false, sink);
        }
    };
    public static final BulkIndexWriter<Map.Entry<String, String>> AUTOCOMPLETE = new BulkIndexWriter<Map.Entry<String, String>>(){

        @Override
        public String writeDocument(Map.Entry<String, String> input, BufferedSink sink) {
            3.writeAutocompleteEntry(input.getKey(), input.getValue(), JsonWriter.of((BufferedSink)sink));
            return input.getKey() + "=" + input.getValue();
        }
    };
    static final Endpoint EMPTY_ENDPOINT = Endpoint.newBuilder().build();

    public abstract String writeDocument(T var1, BufferedSink var2);

    static String write(Span span, boolean searchEnabled, BufferedSink sink) {
        HashingSink hashingSink = HashingSink.md5((Sink)sink);
        JsonWriter writer = JsonWriter.of((BufferedSink)Okio.buffer((Sink)hashingSink));
        try {
            writer.beginObject();
            if (searchEnabled) {
                BulkIndexWriter.addSearchFields(span, writer);
            }
            writer.name("traceId").value(span.traceId());
            if (span.parentId() != null) {
                writer.name("parentId").value(span.parentId());
            }
            writer.name("id").value(span.id());
            if (span.kind() != null) {
                writer.name("kind").value(span.kind().toString());
            }
            if (span.name() != null) {
                writer.name("name").value(span.name());
            }
            if (span.timestampAsLong() != 0L) {
                writer.name("timestamp").value(span.timestampAsLong());
            }
            if (span.durationAsLong() != 0L) {
                writer.name("duration").value(span.durationAsLong());
            }
            if (span.localEndpoint() != null && !EMPTY_ENDPOINT.equals((Object)span.localEndpoint())) {
                writer.name("localEndpoint");
                BulkIndexWriter.write(span.localEndpoint(), writer);
            }
            if (span.remoteEndpoint() != null && !EMPTY_ENDPOINT.equals((Object)span.remoteEndpoint())) {
                writer.name("remoteEndpoint");
                BulkIndexWriter.write(span.remoteEndpoint(), writer);
            }
            if (!span.annotations().isEmpty()) {
                writer.name("annotations");
                writer.beginArray();
                int i = 0;
                int length = span.annotations().size();
                while (i < length) {
                    BulkIndexWriter.write((Annotation)span.annotations().get(i++), writer);
                }
                writer.endArray();
            }
            if (!span.tags().isEmpty()) {
                writer.name("tags");
                writer.beginObject();
                Iterator tags = span.tags().entrySet().iterator();
                while (tags.hasNext()) {
                    BulkIndexWriter.write(tags.next(), writer);
                }
                writer.endObject();
            }
            if (Boolean.TRUE.equals(span.debug())) {
                writer.name("debug").value(true);
            }
            if (Boolean.TRUE.equals(span.shared())) {
                writer.name("shared").value(true);
            }
            writer.endObject();
            writer.flush();
            hashingSink.flush();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return new Buffer().writeUtf8(span.traceId()).writeByte(45).writeUtf8(hashingSink.hash().hex()).readUtf8();
    }

    static void writeAutocompleteEntry(String key, String value, JsonWriter writer) {
        try {
            writer.beginObject();
            writer.name("tagKey").value(key);
            writer.name("tagValue").value(value);
            writer.endObject();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    static void write(Map.Entry<String, String> tag, JsonWriter writer) throws IOException {
        writer.name(tag.getKey()).value(tag.getValue());
    }

    static void write(Annotation annotation, JsonWriter writer) throws IOException {
        writer.beginObject();
        writer.name("timestamp").value(annotation.timestamp());
        writer.name("value").value(annotation.value());
        writer.endObject();
    }

    static void write(Endpoint endpoint, JsonWriter writer) throws IOException {
        writer.beginObject();
        if (endpoint.serviceName() != null) {
            writer.name("serviceName").value(endpoint.serviceName());
        }
        if (endpoint.ipv4() != null) {
            writer.name("ipv4").value(endpoint.ipv4());
        }
        if (endpoint.ipv6() != null) {
            writer.name("ipv6").value(endpoint.ipv6());
        }
        if (endpoint.portAsInt() != 0) {
            writer.name("port").value((long)endpoint.portAsInt());
        }
        writer.endObject();
    }

    static void addSearchFields(Span span, JsonWriter writer) throws IOException {
        long timestampMillis = span.timestampAsLong() / 1000L;
        if (timestampMillis != 0L) {
            writer.name("timestamp_millis").value(timestampMillis);
        }
        if (!span.tags().isEmpty() || !span.annotations().isEmpty()) {
            writer.name("_q");
            writer.beginArray();
            for (Annotation annotation : span.annotations()) {
                if (annotation.value().length() > 256) continue;
                writer.value(annotation.value());
            }
            for (Map.Entry entry : span.tags().entrySet()) {
                int length = ((String)entry.getKey()).length() + ((String)entry.getValue()).length() + 1;
                if (length > 256) continue;
                writer.value((String)entry.getKey());
                writer.value((String)entry.getKey() + "=" + (String)entry.getValue());
            }
            writer.endArray();
        }
    }
}

