/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import zipkin2.Call;
import zipkin2.Callback;

public final class HttpCall<V>
extends Call.Base<V> {
    public final okhttp3.Call call;
    public final BodyConverter<V> bodyConverter;
    final Semaphore semaphore;

    HttpCall(Factory factory, Request request, BodyConverter<V> bodyConverter) {
        this(factory.ok.newCall(request), factory.semaphore, bodyConverter);
    }

    HttpCall(okhttp3.Call call, Semaphore semaphore, BodyConverter<V> bodyConverter) {
        this.call = call;
        this.semaphore = semaphore;
        this.bodyConverter = bodyConverter;
    }

    protected V doExecute() throws IOException {
        if (!this.semaphore.tryAcquire()) {
            throw new IllegalStateException("over capacity");
        }
        try {
            V v = HttpCall.parseResponse(this.call.execute(), this.bodyConverter);
            return v;
        }
        finally {
            this.semaphore.release();
        }
    }

    protected void doEnqueue(Callback<V> callback) {
        if (!this.semaphore.tryAcquire()) {
            callback.onError((Throwable)new IllegalStateException("over capacity"));
            return;
        }
        this.call.enqueue(new V2CallbackAdapter<V>(this.semaphore, this.bodyConverter, callback));
    }

    protected void doCancel() {
        this.call.cancel();
    }

    public HttpCall<V> clone() {
        return new HttpCall<V>(this.call.clone(), this.semaphore, this.bodyConverter);
    }

    public String toString() {
        return "HttpCall(" + this.call + ")";
    }

    public static <V> V parseResponse(Response response, BodyConverter<V> bodyConverter) throws IOException {
        if (!HttpHeaders.hasBody((Response)response)) {
            if (response.isSuccessful()) {
                return null;
            }
            throw new IllegalStateException("response failed: " + response);
        }
        try (ResponseBody responseBody = response.body();){
            BufferedSource content = responseBody.source();
            if ("gzip".equalsIgnoreCase(response.header("Content-Encoding"))) {
                content = Okio.buffer((Source)new GzipSource((Source)responseBody.source()));
            }
            if (response.isSuccessful()) {
                V v = bodyConverter.convert(content);
                return v;
            }
            throw new IllegalStateException("response for " + response.request().tag() + " failed: " + content.readUtf8());
        }
    }

    static class V2CallbackAdapter<V>
    implements okhttp3.Callback {
        final Semaphore semaphore;
        final BodyConverter<V> bodyConverter;
        final Callback<V> delegate;

        V2CallbackAdapter(Semaphore semaphore, BodyConverter<V> bodyConverter, Callback<V> delegate) {
            this.semaphore = semaphore;
            this.bodyConverter = bodyConverter;
            this.delegate = delegate;
        }

        public void onFailure(okhttp3.Call call, IOException e) {
            this.semaphore.release();
            this.delegate.onError((Throwable)e);
        }

        public void onResponse(okhttp3.Call call, Response response) {
            this.semaphore.release();
            try {
                this.delegate.onSuccess(HttpCall.parseResponse(response, this.bodyConverter));
            }
            catch (Throwable e) {
                Call.propagateIfFatal((Throwable)e);
                this.delegate.onError(e);
            }
        }
    }

    public static class Factory
    implements Closeable {
        final OkHttpClient ok;
        final Semaphore semaphore;
        public final HttpUrl baseUrl;

        public Factory(OkHttpClient ok, HttpUrl baseUrl) {
            this.ok = ok;
            this.semaphore = new Semaphore(ok.dispatcher().getMaxRequests());
            this.baseUrl = baseUrl;
        }

        public <V> HttpCall<V> newCall(Request request, BodyConverter<V> bodyConverter) {
            return new HttpCall<V>(this, request, bodyConverter);
        }

        @Override
        public void close() {
            this.ok.dispatcher().executorService().shutdownNow();
        }
    }

    public static interface BodyConverter<V> {
        public V convert(BufferedSource var1) throws IOException;
    }
}

