package zipkin2.elasticsearch;

import java.lang.Override;
import java.lang.String;
import java.util.List;
import okhttp3.OkHttpClient;
import zipkin2.elasticsearch.internal.IndexNameFormatter;
import zipkin2.elasticsearch.internal.client.HttpCall;

final class AutoValue_ElasticsearchStorage extends $AutoValue_ElasticsearchStorage {
  private transient volatile IndexTemplates ensureIndexTemplates;

  private transient volatile HttpCall.Factory http;

  AutoValue_ElasticsearchStorage(OkHttpClient client$, boolean shutdownClientOnClose$,
      ElasticsearchStorage.HostsSupplier hostsSupplier$, String pipeline$, boolean flushOnWrites$,
      int maxRequests$, boolean strictTraceId$, boolean searchEnabled$,
      List<String> autocompleteKeys$, int autocompleteTtl$, int autocompleteCardinality$,
      int indexShards$, int indexReplicas$, IndexNameFormatter indexNameFormatter$,
      int namesLookback$) {
    super(client$, shutdownClientOnClose$, hostsSupplier$, pipeline$, flushOnWrites$, maxRequests$, strictTraceId$, searchEnabled$, autocompleteKeys$, autocompleteTtl$, autocompleteCardinality$, indexShards$, indexReplicas$, indexNameFormatter$, namesLookback$);
  }

  @Override
  IndexTemplates ensureIndexTemplates() {
    if (ensureIndexTemplates == null) {
      synchronized (this) {
        if (ensureIndexTemplates == null) {
          ensureIndexTemplates = super.ensureIndexTemplates();
          if (ensureIndexTemplates == null) {
            throw new NullPointerException("ensureIndexTemplates() cannot return null");
          }
        }
      }
    }
    return ensureIndexTemplates;
  }

  @Override
  public HttpCall.Factory http() {
    if (http == null) {
      synchronized (this) {
        if (http == null) {
          http = super.http();
          if (http == null) {
            throw new NullPointerException("http() cannot return null");
          }
        }
      }
    }
    return http;
  }
}
