/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal;

import com.google.auto.value.AutoValue;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.internal.AutoValue_BulkCallBuilder_IndexEntry;
import zipkin2.elasticsearch.internal.BulkIndexWriter;
import zipkin2.elasticsearch.internal.client.HttpCall;

public final class BulkCallBuilder {
    static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    final String tag;
    final boolean shouldAddType;
    final HttpCall.Factory http;
    final String pipeline;
    final boolean waitForRefresh;
    final List<IndexEntry<?>> entries = new ArrayList();

    public BulkCallBuilder(ElasticsearchStorage es, float esVersion, String tag) {
        this.tag = tag;
        this.shouldAddType = esVersion < 7.0f;
        this.http = es.http();
        this.pipeline = es.pipeline();
        this.waitForRefresh = es.flushOnWrites();
    }

    static <T> IndexEntry<T> newIndexEntry(String index, String typeName, T input, BulkIndexWriter<T> writer) {
        return new AutoValue_BulkCallBuilder_IndexEntry<T>(index, typeName, input, writer);
    }

    public <T> void index(String index, String typeName, T input, BulkIndexWriter<T> writer) {
        this.entries.add(BulkCallBuilder.newIndexEntry(index, typeName, input, writer));
    }

    public HttpCall<Void> build() {
        HttpUrl.Builder urlBuilder = this.http.baseUrl.newBuilder("_bulk");
        if (this.pipeline != null) {
            urlBuilder.addQueryParameter("pipeline", this.pipeline);
        }
        if (this.waitForRefresh) {
            urlBuilder.addQueryParameter("refresh", "wait_for");
        }
        BulkRequestBody body = new BulkRequestBody(this.entries, this.shouldAddType);
        Request request = new Request.Builder().url(urlBuilder.build()).tag((Object)this.tag).post((RequestBody)body).build();
        return this.http.newCall(request, CheckForErrors.INSTANCE);
    }

    static void write(BufferedSink sink, IndexEntry entry, boolean shouldAddType) throws IOException {
        Buffer document = new Buffer();
        String id = entry.writer().writeDocument(entry.input(), (BufferedSink)document);
        BulkCallBuilder.writeIndexMetadata(sink, entry, id, shouldAddType);
        sink.writeByte(10);
        sink.write(document, document.size());
        sink.writeByte(10);
    }

    static void writeIndexMetadata(BufferedSink sink, IndexEntry entry, String id, boolean shouldAddType) {
        JsonWriter jsonWriter = JsonWriter.of((BufferedSink)sink);
        try {
            jsonWriter.beginObject();
            jsonWriter.name("index");
            jsonWriter.beginObject();
            jsonWriter.name("_index").value(entry.index());
            if (shouldAddType) {
                jsonWriter.name("_type").value(entry.typeName());
            }
            jsonWriter.name("_id").value(id);
            jsonWriter.endObject();
            jsonWriter.endObject();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    static enum CheckForErrors implements HttpCall.BodyConverter<Void>
    {
        INSTANCE;


        @Override
        public Void convert(BufferedSource b) throws IOException {
            String content = b.readUtf8();
            if (content.contains("\"status\":429")) {
                throw new RejectedExecutionException(content);
            }
            if (content.contains("\"errors\":true")) {
                throw new IllegalStateException(content);
            }
            return null;
        }

        public String toString() {
            return "CheckForErrors";
        }
    }

    static final class BulkRequestBody
    extends RequestBody {
        final List<IndexEntry<?>> entries;
        final boolean shouldAddType;

        BulkRequestBody(List<IndexEntry<?>> entries, boolean shouldAddType) {
            this.entries = entries;
            this.shouldAddType = shouldAddType;
        }

        public MediaType contentType() {
            return APPLICATION_JSON;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            int length = this.entries.size();
            for (int i = 0; i < length; ++i) {
                BulkCallBuilder.write(sink, this.entries.get(i), this.shouldAddType);
            }
        }
    }

    @AutoValue
    static abstract class IndexEntry<T> {
        IndexEntry() {
        }

        abstract String index();

        abstract String typeName();

        abstract T input();

        abstract BulkIndexWriter<T> writer();
    }
}

