

package zipkin2.elasticsearch;

// Generated by com.google.auto.value.processor.AutoValueProcessor
final class AutoValue_IndexTemplates extends IndexTemplates {

  private final float version;

  private final char indexTypeDelimiter;

  private final String span;

  private final String dependency;

  private final String autocomplete;

  private AutoValue_IndexTemplates(
      float version,
      char indexTypeDelimiter,
      String span,
      String dependency,
      String autocomplete) {
    this.version = version;
    this.indexTypeDelimiter = indexTypeDelimiter;
    this.span = span;
    this.dependency = dependency;
    this.autocomplete = autocomplete;
  }

  @Override
  float version() {
    return version;
  }

  @Override
  char indexTypeDelimiter() {
    return indexTypeDelimiter;
  }

  @Override
  String span() {
    return span;
  }

  @Override
  String dependency() {
    return dependency;
  }

  @Override
  String autocomplete() {
    return autocomplete;
  }

  @Override
  public String toString() {
    return "IndexTemplates{"
         + "version=" + version + ", "
         + "indexTypeDelimiter=" + indexTypeDelimiter + ", "
         + "span=" + span + ", "
         + "dependency=" + dependency + ", "
         + "autocomplete=" + autocomplete
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof IndexTemplates) {
      IndexTemplates that = (IndexTemplates) o;
      return Float.floatToIntBits(this.version) == Float.floatToIntBits(that.version())
          && this.indexTypeDelimiter == that.indexTypeDelimiter()
          && this.span.equals(that.span())
          && this.dependency.equals(that.dependency())
          && this.autocomplete.equals(that.autocomplete());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= Float.floatToIntBits(version);
    h$ *= 1000003;
    h$ ^= indexTypeDelimiter;
    h$ *= 1000003;
    h$ ^= span.hashCode();
    h$ *= 1000003;
    h$ ^= dependency.hashCode();
    h$ *= 1000003;
    h$ ^= autocomplete.hashCode();
    return h$;
  }

  static final class Builder implements IndexTemplates.Builder {
    private Float version;
    private Character indexTypeDelimiter;
    private String span;
    private String dependency;
    private String autocomplete;
    Builder() {
    }
    @Override
    public IndexTemplates.Builder version(float version) {
      this.version = version;
      return this;
    }
    @Override
    public IndexTemplates.Builder indexTypeDelimiter(char indexTypeDelimiter) {
      this.indexTypeDelimiter = indexTypeDelimiter;
      return this;
    }
    @Override
    public IndexTemplates.Builder span(String span) {
      if (span == null) {
        throw new NullPointerException("Null span");
      }
      this.span = span;
      return this;
    }
    @Override
    public IndexTemplates.Builder dependency(String dependency) {
      if (dependency == null) {
        throw new NullPointerException("Null dependency");
      }
      this.dependency = dependency;
      return this;
    }
    @Override
    public IndexTemplates.Builder autocomplete(String autocomplete) {
      if (autocomplete == null) {
        throw new NullPointerException("Null autocomplete");
      }
      this.autocomplete = autocomplete;
      return this;
    }
    @Override
    public IndexTemplates build() {
      String missing = "";
      if (this.version == null) {
        missing += " version";
      }
      if (this.indexTypeDelimiter == null) {
        missing += " indexTypeDelimiter";
      }
      if (this.span == null) {
        missing += " span";
      }
      if (this.dependency == null) {
        missing += " dependency";
      }
      if (this.autocomplete == null) {
        missing += " autocomplete";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_IndexTemplates(
          this.version,
          this.indexTypeDelimiter,
          this.span,
          this.dependency,
          this.autocomplete);
    }
  }

}
