/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.auto.value.AutoValue;
import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestHeaders;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.codec.http.QueryStringEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.internal.AutoValue_BulkCallBuilder_IndexEntry;
import zipkin2.elasticsearch.internal.BulkIndexWriter;
import zipkin2.elasticsearch.internal.Internal;
import zipkin2.elasticsearch.internal.JsonSerializers;
import zipkin2.elasticsearch.internal.client.HttpCall;

public final class BulkCallBuilder {
    static final HttpCall.BodyConverter<Void> CHECK_FOR_ERRORS = new HttpCall.BodyConverter<Void>(){

        @Override
        public Void convert(JsonParser parser, Supplier<String> contentString) {
            RuntimeException toThrow = null;
            try {
                Number status;
                JsonNode root = (JsonNode)JsonSerializers.OBJECT_MAPPER.readTree(parser);
                if (!root.at("/errors").booleanValue() && !root.at("/error").isObject()) {
                    return null;
                }
                String message = root.findPath("reason").textValue();
                if (message == null) {
                    message = contentString.get();
                }
                toThrow = (status = root.findPath("status").numberValue()) != null && status.intValue() == 429 ? new RejectedExecutionException(message) : new RuntimeException(message);
            }
            catch (IOException | RuntimeException exception) {
                // empty catch block
            }
            if (toThrow != null) {
                throw toThrow;
            }
            return null;
        }

        public String toString() {
            return "CheckForErrors";
        }
    };
    final String tag;
    final boolean shouldAddType;
    final HttpCall.Factory http;
    final String pipeline;
    final boolean waitForRefresh;
    final List<IndexEntry<?>> entries = new ArrayList();

    public BulkCallBuilder(ElasticsearchStorage es, float esVersion, String tag) {
        this.tag = tag;
        this.shouldAddType = esVersion < 7.0f;
        this.http = Internal.instance.http(es);
        this.pipeline = es.pipeline();
        this.waitForRefresh = es.flushOnWrites();
    }

    static <T> IndexEntry<T> newIndexEntry(String index, String typeName, T input, BulkIndexWriter<T> writer) {
        return new AutoValue_BulkCallBuilder_IndexEntry<T>(index, typeName, input, writer);
    }

    public <T> void index(String index, String typeName, T input, BulkIndexWriter<T> writer) {
        this.entries.add(BulkCallBuilder.newIndexEntry(index, typeName, input, writer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpCall<Void> build() {
        HttpData body;
        QueryStringEncoder urlBuilder = new QueryStringEncoder("/_bulk");
        if (this.pipeline != null) {
            urlBuilder.addParam("pipeline", this.pipeline);
        }
        if (this.waitForRefresh) {
            urlBuilder.addParam("refresh", "wait_for");
        }
        CompositeByteBuf sink = ((ByteBufAllocator)RequestContext.mapCurrent(RequestContext::alloc, () -> PooledByteBufAllocator.DEFAULT)).compositeHeapBuffer(Integer.MAX_VALUE);
        try {
            for (IndexEntry<?> entry : this.entries) {
                BulkCallBuilder.write(sink, entry, this.shouldAddType);
            }
            body = HttpData.wrap((byte[])ByteBufUtil.getBytes((ByteBuf)sink));
        }
        finally {
            sink.release();
        }
        AggregatedHttpRequest request = AggregatedHttpRequest.of((RequestHeaders)RequestHeaders.of((HttpMethod)HttpMethod.POST, (String)urlBuilder.toString(), (CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)MediaType.JSON_UTF_8), (HttpData)body);
        return this.http.newCall(request, CHECK_FOR_ERRORS, this.tag);
    }

    static <T> void write(CompositeByteBuf sink, IndexEntry<T> entry, boolean shouldAddType) {
        ByteBuf document = sink.alloc().heapBuffer(600).writeByte(10);
        ByteBuf metadata = sink.alloc().heapBuffer(200);
        try {
            String id = entry.writer().writeDocument(entry.input(), new ByteBufOutputStream(document));
            document.writeByte(10);
            BulkCallBuilder.writeIndexMetadata(new ByteBufOutputStream(metadata), entry, id, shouldAddType);
        }
        catch (Throwable t) {
            document.release();
            metadata.release();
            throw t;
        }
        sink.addComponent(true, metadata).addComponent(true, document);
    }

    static <T> void writeIndexMetadata(ByteBufOutputStream sink, IndexEntry<T> entry, String id, boolean shouldAddType) {
        try (JsonGenerator writer = JsonSerializers.jsonGenerator((OutputStream)sink);){
            writer.writeStartObject();
            writer.writeObjectFieldStart("index");
            writer.writeStringField("_index", entry.index());
            if (shouldAddType) {
                writer.writeStringField("_type", entry.typeName());
            }
            writer.writeStringField("_id", id);
            writer.writeEndObject();
            writer.writeEndObject();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @AutoValue
    static abstract class IndexEntry<T> {
        IndexEntry() {
        }

        abstract String index();

        abstract String typeName();

        abstract T input();

        abstract BulkIndexWriter<T> writer();
    }
}

