/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Map;
import zipkin2.Annotation;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.elasticsearch.internal.JsonSerializers;

public abstract class BulkIndexWriter<T> {
    public static final BulkIndexWriter<Span> SPAN = new BulkIndexWriter<Span>(){

        @Override
        public String writeDocument(Span input, ByteBufOutputStream sink) {
            return 1.write(input, true, sink);
        }
    };
    public static final BulkIndexWriter<Span> SPAN_SEARCH_DISABLED = new BulkIndexWriter<Span>(){

        @Override
        public String writeDocument(Span input, ByteBufOutputStream sink) {
            return 2.write(input, false, sink);
        }
    };
    public static final BulkIndexWriter<Map.Entry<String, String>> AUTOCOMPLETE = new BulkIndexWriter<Map.Entry<String, String>>(){

        @Override
        public String writeDocument(Map.Entry<String, String> input, ByteBufOutputStream sink) {
            try (JsonGenerator writer = JsonSerializers.jsonGenerator((OutputStream)sink);){
                3.writeAutocompleteEntry(input.getKey(), input.getValue(), writer);
            }
            catch (IOException e) {
                throw new AssertionError("Couldn't close generator for a memory stream.", e);
            }
            return input.getKey() + '=' + input.getValue();
        }
    };
    static final Endpoint EMPTY_ENDPOINT = Endpoint.newBuilder().build();

    public abstract String writeDocument(T var1, ByteBufOutputStream var2);

    static String write(Span span, boolean searchEnabled, ByteBufOutputStream sink) {
        int startIndex = sink.buffer().writerIndex();
        try (JsonGenerator writer = JsonSerializers.jsonGenerator((OutputStream)sink);){
            writer.writeStartObject();
            if (searchEnabled) {
                BulkIndexWriter.addSearchFields(span, writer);
            }
            writer.writeStringField("traceId", span.traceId());
            if (span.parentId() != null) {
                writer.writeStringField("parentId", span.parentId());
            }
            writer.writeStringField("id", span.id());
            if (span.kind() != null) {
                writer.writeStringField("kind", span.kind().toString());
            }
            if (span.name() != null) {
                writer.writeStringField("name", span.name());
            }
            if (span.timestampAsLong() != 0L) {
                writer.writeNumberField("timestamp", span.timestampAsLong());
            }
            if (span.durationAsLong() != 0L) {
                writer.writeNumberField("duration", span.durationAsLong());
            }
            if (span.localEndpoint() != null && !EMPTY_ENDPOINT.equals((Object)span.localEndpoint())) {
                writer.writeFieldName("localEndpoint");
                BulkIndexWriter.write(span.localEndpoint(), writer);
            }
            if (span.remoteEndpoint() != null && !EMPTY_ENDPOINT.equals((Object)span.remoteEndpoint())) {
                writer.writeFieldName("remoteEndpoint");
                BulkIndexWriter.write(span.remoteEndpoint(), writer);
            }
            if (!span.annotations().isEmpty()) {
                writer.writeArrayFieldStart("annotations");
                int i = 0;
                int length = span.annotations().size();
                while (i < length) {
                    BulkIndexWriter.write((Annotation)span.annotations().get(i++), writer);
                }
                writer.writeEndArray();
            }
            if (!span.tags().isEmpty()) {
                writer.writeObjectFieldStart("tags");
                Iterator tags = span.tags().entrySet().iterator();
                while (tags.hasNext()) {
                    BulkIndexWriter.write(tags.next(), writer);
                }
                writer.writeEndObject();
            }
            if (Boolean.TRUE.equals(span.debug())) {
                writer.writeBooleanField("debug", true);
            }
            if (Boolean.TRUE.equals(span.shared())) {
                writer.writeBooleanField("shared", true);
            }
            writer.writeEndObject();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        ByteBuf slice = sink.buffer().slice(startIndex, sink.buffer().writerIndex() - startIndex);
        return span.traceId() + '-' + BulkIndexWriter.md5(slice);
    }

    static void writeAutocompleteEntry(String key, String value, JsonGenerator writer) {
        try {
            writer.writeStartObject();
            writer.writeStringField("tagKey", key);
            writer.writeStringField("tagValue", value);
            writer.writeEndObject();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    static void write(Map.Entry<String, String> tag, JsonGenerator writer) throws IOException {
        writer.writeStringField(tag.getKey(), tag.getValue());
    }

    static void write(Annotation annotation, JsonGenerator writer) throws IOException {
        writer.writeStartObject();
        writer.writeNumberField("timestamp", annotation.timestamp());
        writer.writeStringField("value", annotation.value());
        writer.writeEndObject();
    }

    static void write(Endpoint endpoint, JsonGenerator writer) throws IOException {
        writer.writeStartObject();
        if (endpoint.serviceName() != null) {
            writer.writeStringField("serviceName", endpoint.serviceName());
        }
        if (endpoint.ipv4() != null) {
            writer.writeStringField("ipv4", endpoint.ipv4());
        }
        if (endpoint.ipv6() != null) {
            writer.writeStringField("ipv6", endpoint.ipv6());
        }
        if (endpoint.portAsInt() != 0) {
            writer.writeNumberField("port", endpoint.portAsInt());
        }
        writer.writeEndObject();
    }

    static void addSearchFields(Span span, JsonGenerator writer) throws IOException {
        long timestampMillis = span.timestampAsLong() / 1000L;
        if (timestampMillis != 0L) {
            writer.writeNumberField("timestamp_millis", timestampMillis);
        }
        if (!span.tags().isEmpty() || !span.annotations().isEmpty()) {
            writer.writeArrayFieldStart("_q");
            for (Annotation annotation : span.annotations()) {
                if (annotation.value().length() > 256) continue;
                writer.writeString(annotation.value());
            }
            for (Map.Entry entry : span.tags().entrySet()) {
                int length = ((String)entry.getKey()).length() + ((String)entry.getValue()).length() + 1;
                if (length > 256) continue;
                writer.writeString((String)entry.getKey());
                writer.writeString((String)entry.getKey() + "=" + (String)entry.getValue());
            }
            writer.writeEndArray();
        }
    }

    static String md5(ByteBuf buf) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
        messageDigest.update(buf.nioBuffer());
        return ByteBufUtil.hexDump((byte[])messageDigest.digest());
    }
}

