package zipkin2.elasticsearch.internal;

import java.text.SimpleDateFormat;

// Generated by com.google.auto.value.processor.AutoValueProcessor
final class AutoValue_IndexNameFormatter extends IndexNameFormatter {

  private final String index;

  private final char dateSeparator;

  private final ThreadLocal<SimpleDateFormat> dateFormat;

  private AutoValue_IndexNameFormatter(
      String index,
      char dateSeparator,
      ThreadLocal<SimpleDateFormat> dateFormat) {
    this.index = index;
    this.dateSeparator = dateSeparator;
    this.dateFormat = dateFormat;
  }

  @Override
  public String index() {
    return index;
  }

  @Override
  char dateSeparator() {
    return dateSeparator;
  }

  @Override
  ThreadLocal<SimpleDateFormat> dateFormat() {
    return dateFormat;
  }

  @Override
  public String toString() {
    return "IndexNameFormatter{"
         + "index=" + index + ", "
         + "dateSeparator=" + dateSeparator + ", "
         + "dateFormat=" + dateFormat
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof IndexNameFormatter) {
      IndexNameFormatter that = (IndexNameFormatter) o;
      return this.index.equals(that.index())
          && this.dateSeparator == that.dateSeparator()
          && this.dateFormat.equals(that.dateFormat());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= index.hashCode();
    h$ *= 1000003;
    h$ ^= dateSeparator;
    h$ *= 1000003;
    h$ ^= dateFormat.hashCode();
    return h$;
  }

  @Override
  public IndexNameFormatter.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends IndexNameFormatter.Builder {
    private String index;
    private Character dateSeparator;
    private ThreadLocal<SimpleDateFormat> dateFormat;
    Builder() {
    }
    private Builder(IndexNameFormatter source) {
      this.index = source.index();
      this.dateSeparator = source.dateSeparator();
      this.dateFormat = source.dateFormat();
    }
    @Override
    public IndexNameFormatter.Builder index(String index) {
      if (index == null) {
        throw new NullPointerException("Null index");
      }
      this.index = index;
      return this;
    }
    @Override
    public IndexNameFormatter.Builder dateSeparator(char dateSeparator) {
      this.dateSeparator = dateSeparator;
      return this;
    }
    @Override
    char dateSeparator() {
      if (dateSeparator == null) {
        throw new IllegalStateException("Property \"dateSeparator\" has not been set");
      }
      return dateSeparator;
    }
    @Override
    IndexNameFormatter.Builder dateFormat(ThreadLocal<SimpleDateFormat> dateFormat) {
      if (dateFormat == null) {
        throw new NullPointerException("Null dateFormat");
      }
      this.dateFormat = dateFormat;
      return this;
    }
    @Override
    IndexNameFormatter autoBuild() {
      String missing = "";
      if (this.index == null) {
        missing += " index";
      }
      if (this.dateSeparator == null) {
        missing += " dateSeparator";
      }
      if (this.dateFormat == null) {
        missing += " dateFormat";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_IndexNameFormatter(
          this.index,
          this.dateSeparator,
          this.dateFormat);
    }
  }

}
