/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import zipkin2.Annotation;
import zipkin2.Call;
import zipkin2.Span;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.internal.BulkCallBuilder;
import zipkin2.elasticsearch.internal.BulkIndexWriter;
import zipkin2.elasticsearch.internal.IndexNameFormatter;
import zipkin2.elasticsearch.internal.client.HttpCall;
import zipkin2.internal.DelayLimiter;
import zipkin2.storage.SpanConsumer;

class ElasticsearchSpanConsumer
implements SpanConsumer {
    final ElasticsearchStorage es;
    final Set<String> autocompleteKeys;
    final IndexNameFormatter indexNameFormatter;
    final char indexTypeDelimiter;
    final boolean searchEnabled;
    final DelayLimiter<AutocompleteContext> delayLimiter;

    ElasticsearchSpanConsumer(ElasticsearchStorage es) {
        this.es = es;
        this.autocompleteKeys = new LinkedHashSet<String>(es.autocompleteKeys());
        this.indexNameFormatter = es.indexNameFormatter();
        this.indexTypeDelimiter = es.indexTypeDelimiter();
        this.searchEnabled = es.searchEnabled();
        this.delayLimiter = DelayLimiter.newBuilder().ttl(es.autocompleteTtl()).cardinality(es.autocompleteCardinality()).build();
    }

    String formatTypeAndTimestampForInsert(String type, long timestampMillis) {
        return this.indexNameFormatter.formatTypeAndTimestampForInsert(type, this.indexTypeDelimiter, timestampMillis);
    }

    public Call<Void> accept(List<Span> spans) {
        if (spans.isEmpty()) {
            return Call.create(null);
        }
        BulkSpanIndexer indexer = new BulkSpanIndexer(this);
        this.indexSpans(indexer, spans);
        return indexer.newCall();
    }

    void indexSpans(BulkSpanIndexer indexer, List<Span> spans) {
        for (Span span : spans) {
            long indexTimestamp = span.timestampAsLong() != 0L ? span.timestampAsLong() / 1000L : (!span.annotations().isEmpty() ? ((Annotation)span.annotations().get(0)).timestamp() / 1000L : System.currentTimeMillis());
            indexer.add(indexTimestamp, span);
            if (!this.searchEnabled || span.tags().isEmpty()) continue;
            indexer.addAutocompleteValues(indexTimestamp, span);
        }
    }

    static final class BulkSpanIndexer {
        final BulkCallBuilder bulkCallBuilder;
        final ElasticsearchSpanConsumer consumer;
        final List<AutocompleteContext> pendingAutocompleteContexts = new ArrayList<AutocompleteContext>();
        final BulkIndexWriter<Span> spanWriter;

        BulkSpanIndexer(ElasticsearchSpanConsumer consumer) {
            this.bulkCallBuilder = new BulkCallBuilder(consumer.es, consumer.es.version(), "index-span");
            this.consumer = consumer;
            this.spanWriter = consumer.searchEnabled ? BulkIndexWriter.SPAN : BulkIndexWriter.SPAN_SEARCH_DISABLED;
        }

        void add(long indexTimestamp, Span span) {
            String index = this.consumer.formatTypeAndTimestampForInsert("span", indexTimestamp);
            this.bulkCallBuilder.index(index, "span", span, this.spanWriter);
        }

        void addAutocompleteValues(long indexTimestamp, Span span) {
            String idx = this.consumer.formatTypeAndTimestampForInsert("autocomplete", indexTimestamp);
            for (Map.Entry tag : span.tags().entrySet()) {
                AutocompleteContext context;
                int length = ((String)tag.getKey()).length() + ((String)tag.getValue()).length() + 1;
                if (length > 256 || !this.consumer.autocompleteKeys.contains(tag.getKey()) || !this.consumer.delayLimiter.shouldInvoke((Object)(context = new AutocompleteContext(indexTimestamp, (String)tag.getKey(), (String)tag.getValue())))) continue;
                this.pendingAutocompleteContexts.add(context);
                this.bulkCallBuilder.index(idx, "autocomplete", tag, BulkIndexWriter.AUTOCOMPLETE);
            }
        }

        Call<Void> newCall() {
            HttpCall<Void> storeCall = this.bulkCallBuilder.build();
            if (this.pendingAutocompleteContexts.isEmpty()) {
                return storeCall;
            }
            return storeCall.handleError((error, callback) -> {
                for (AutocompleteContext context : this.pendingAutocompleteContexts) {
                    this.consumer.delayLimiter.invalidate((Object)context);
                }
                callback.onError(error);
            });
        }
    }

    static final class AutocompleteContext {
        final long timestamp;
        final String key;
        final String value;

        AutocompleteContext(long timestamp, String key, String value) {
            this.timestamp = timestamp;
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AutocompleteContext)) {
                return false;
            }
            AutocompleteContext that = (AutocompleteContext)o;
            return this.timestamp == that.timestamp && this.key.equals(that.key) && this.value.equals(that.value);
        }

        public int hashCode() {
            int h$ = 1;
            h$ *= 1000003;
            h$ ^= (int)((long)h$ ^ (this.timestamp >>> 32 ^ this.timestamp));
            h$ *= 1000003;
            h$ ^= this.key.hashCode();
            h$ *= 1000003;
            return h$ ^= this.value.hashCode();
        }
    }
}

