/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch;

import com.fasterxml.jackson.core.JsonParser;
import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpMethod;
import java.io.IOException;
import java.util.function.Supplier;
import zipkin2.elasticsearch.internal.JsonReaders;
import zipkin2.elasticsearch.internal.client.HttpCall;

enum ElasticsearchVersion implements HttpCall.BodyConverter<Float>
{
    INSTANCE;


    float get(HttpCall.Factory callFactory) throws IOException {
        AggregatedHttpRequest getNode = AggregatedHttpRequest.of((HttpMethod)HttpMethod.GET, (String)"/");
        Float version = (Float)callFactory.newCall(getNode, this, "get-node").execute();
        if (version == null) {
            throw new IllegalArgumentException("No content reading Elasticsearch version");
        }
        return version.floatValue();
    }

    @Override
    public Float convert(JsonParser parser, Supplier<String> contentString) {
        String version = null;
        try {
            if (JsonReaders.enterPath(parser, "version", "number") != null) {
                version = parser.getText();
            }
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
        if (version == null) {
            throw new IllegalArgumentException(".version.number not found in response: " + contentString.get());
        }
        return Float.valueOf(version.substring(0, 3));
    }
}

