/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestHeaders;
import java.util.List;
import zipkin2.elasticsearch.internal.JsonSerializers;
import zipkin2.elasticsearch.internal.client.HttpCall;
import zipkin2.elasticsearch.internal.client.SearchRequest;
import zipkin2.internal.Nullable;

public class SearchCallFactory {
    final HttpCall.Factory http;

    public SearchCallFactory(HttpCall.Factory http) {
        this.http = http;
    }

    public <V> HttpCall<V> newCall(SearchRequest request, HttpCall.BodyConverter<V> bodyConverter) {
        AggregatedHttpRequest httpRequest;
        try {
            httpRequest = AggregatedHttpRequest.of((RequestHeaders)RequestHeaders.of((HttpMethod)HttpMethod.POST, (String)this.lenientSearch(request.indices, request.type), (CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)MediaType.JSON_UTF_8), (HttpData)HttpData.wrap((byte[])JsonSerializers.OBJECT_MAPPER.writeValueAsBytes((Object)request)));
        }
        catch (JsonProcessingException e) {
            throw new AssertionError("Could not serialize SearchRequest to bytes.", e);
        }
        return this.http.newCall(httpRequest, bodyConverter, request.tag());
    }

    String lenientSearch(List<String> indices, @Nullable String type) {
        return '/' + String.join((CharSequence)",", indices) + "/_search?allow_no_indices=true&expand_wildcards=open&ignore_unavailable=true";
    }
}

