/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch;

import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import zipkin2.DependencyLink;
import zipkin2.Span;
import zipkin2.elasticsearch.internal.JsonReaders;
import zipkin2.elasticsearch.internal.JsonSerializers;
import zipkin2.elasticsearch.internal.client.HttpCall;
import zipkin2.elasticsearch.internal.client.SearchResultConverter;
import zipkin2.internal.DependencyLinker;

final class BodyConverters {
    static final HttpCall.BodyConverter<Object> NULL = (parser, contentString) -> null;
    static final HttpCall.BodyConverter<List<String>> KEYS = (parser, contentString) -> JsonReaders.collectValuesNamed(parser, "key");
    static final HttpCall.BodyConverter<List<Span>> SPANS = SearchResultConverter.create(JsonSerializers.SPAN_PARSER);
    static final HttpCall.BodyConverter<List<DependencyLink>> DEPENDENCY_LINKS = new SearchResultConverter<DependencyLink>(JsonSerializers.DEPENDENCY_LINK_PARSER){

        @Override
        public List<DependencyLink> convert(JsonParser parser, Supplier<String> contentString) throws IOException {
            Object result = super.convert(parser, (Supplier)contentString);
            return result.isEmpty() ? result : DependencyLinker.merge((Iterable)result);
        }
    };

    BodyConverters() {
    }
}

