/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import zipkin2.Call;
import zipkin2.DependencyLink;
import zipkin2.Span;
import zipkin2.elasticsearch.BodyConverters;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.internal.IndexNameFormatter;
import zipkin2.elasticsearch.internal.client.Aggregation;
import zipkin2.elasticsearch.internal.client.HttpCall;
import zipkin2.elasticsearch.internal.client.SearchCallFactory;
import zipkin2.elasticsearch.internal.client.SearchRequest;
import zipkin2.storage.GroupByTraceId;
import zipkin2.storage.QueryRequest;
import zipkin2.storage.ServiceAndSpanNames;
import zipkin2.storage.SpanStore;
import zipkin2.storage.StrictTraceId;
import zipkin2.storage.Traces;

final class ElasticsearchSpanStore
implements SpanStore,
Traces,
ServiceAndSpanNames {
    static final long EARLIEST_MS = 1456790400000L;
    final SearchCallFactory search;
    final Call.Mapper<List<Span>, List<List<Span>>> groupByTraceId;
    final String[] allSpanIndices;
    final IndexNameFormatter indexNameFormatter;
    final boolean strictTraceId;
    final boolean searchEnabled;
    final int namesLookback;

    ElasticsearchSpanStore(ElasticsearchStorage es) {
        this.search = new SearchCallFactory(es.http());
        this.groupByTraceId = GroupByTraceId.create((boolean)es.strictTraceId());
        this.allSpanIndices = new String[]{es.indexNameFormatter().formatType("span")};
        this.indexNameFormatter = es.indexNameFormatter();
        this.strictTraceId = es.strictTraceId();
        this.searchEnabled = es.searchEnabled();
        this.namesLookback = es.namesLookback();
    }

    public Call<List<List<Span>>> getTraces(QueryRequest request) {
        if (!this.searchEnabled) {
            return Call.emptyList();
        }
        long endMillis = request.endTs();
        long beginMillis = Math.max(endMillis - request.lookback(), 1456790400000L);
        SearchRequest.Filters filters = new SearchRequest.Filters();
        filters.addRange("timestamp_millis", beginMillis, endMillis);
        if (request.serviceName() != null) {
            filters.addTerm("localEndpoint.serviceName", request.serviceName());
        }
        if (request.remoteServiceName() != null) {
            filters.addTerm("remoteEndpoint.serviceName", request.remoteServiceName());
        }
        if (request.spanName() != null) {
            filters.addTerm("name", request.spanName());
        }
        for (Map.Entry kv : request.annotationQuery().entrySet()) {
            if (((String)kv.getValue()).isEmpty()) {
                filters.addTerm("_q", (String)kv.getKey());
                continue;
            }
            filters.addTerm("_q", (String)kv.getKey() + "=" + (String)kv.getValue());
        }
        if (request.minDuration() != null) {
            filters.addRange("duration", request.minDuration(), request.maxDuration());
        }
        Aggregation traceIdTimestamp = Aggregation.terms("traceId", request.limit()).addSubAggregation(Aggregation.min("timestamp_millis")).orderBy("timestamp_millis", "desc");
        List<String> indices = this.indexNameFormatter.formatTypeAndRange("span", beginMillis, endMillis);
        if (indices.isEmpty()) {
            return Call.emptyList();
        }
        SearchRequest esRequest = SearchRequest.create(indices).filters(filters).addAggregation(traceIdTimestamp);
        HttpCall<List<String>> traceIdsCall = this.search.newCall(esRequest, BodyConverters.KEYS);
        Call result = traceIdsCall.flatMap(new GetSpansByTraceId(this.search, indices)).map(this.groupByTraceId);
        return this.strictTraceId ? result.map(StrictTraceId.filterTraces((QueryRequest)request)) : result;
    }

    public Call<List<Span>> getTrace(String traceId) {
        traceId = Span.normalizeTraceId((String)traceId);
        if (!this.strictTraceId && traceId.length() == 32) {
            traceId = traceId.substring(16);
        }
        SearchRequest request = SearchRequest.create(Arrays.asList(this.allSpanIndices)).term("traceId", traceId);
        return this.search.newCall(request, BodyConverters.SPANS);
    }

    public Call<List<List<Span>>> getTraces(Iterable<String> traceIds) {
        LinkedHashSet<String> normalizedTraceIds = new LinkedHashSet<String>();
        for (String traceId : traceIds) {
            traceId = Span.normalizeTraceId((String)traceId);
            if (!this.strictTraceId && traceId.length() == 32) {
                traceId = traceId.substring(16);
            }
            normalizedTraceIds.add(traceId);
        }
        if (normalizedTraceIds.isEmpty()) {
            return Call.emptyList();
        }
        SearchRequest request = SearchRequest.create(Arrays.asList(this.allSpanIndices)).terms("traceId", normalizedTraceIds);
        return this.search.newCall(request, BodyConverters.SPANS).map(this.groupByTraceId);
    }

    public Call<List<String>> getServiceNames() {
        if (!this.searchEnabled) {
            return Call.emptyList();
        }
        long endMillis = System.currentTimeMillis();
        long beginMillis = endMillis - (long)this.namesLookback;
        List<String> indices = this.indexNameFormatter.formatTypeAndRange("span", beginMillis, endMillis);
        if (indices.isEmpty()) {
            return Call.emptyList();
        }
        SearchRequest request = SearchRequest.create(indices).filters(new SearchRequest.Filters().addRange("timestamp_millis", beginMillis, endMillis)).addAggregation(Aggregation.terms("localEndpoint.serviceName", Integer.MAX_VALUE));
        return this.search.newCall(request, BodyConverters.KEYS);
    }

    public Call<List<String>> getRemoteServiceNames(String serviceName) {
        return this.aggregatedFieldByServiceName(serviceName, "remoteEndpoint.serviceName");
    }

    public Call<List<String>> getSpanNames(String serviceName) {
        return this.aggregatedFieldByServiceName(serviceName, "name");
    }

    Call<List<String>> aggregatedFieldByServiceName(String serviceName, String term) {
        if (serviceName.isEmpty() || !this.searchEnabled) {
            return Call.emptyList();
        }
        long endMillis = System.currentTimeMillis();
        long beginMillis = endMillis - (long)this.namesLookback;
        List<String> indices = this.indexNameFormatter.formatTypeAndRange("span", beginMillis, endMillis);
        if (indices.isEmpty()) {
            return Call.emptyList();
        }
        SearchRequest.Filters filters = new SearchRequest.Filters().addRange("timestamp_millis", beginMillis, endMillis).addTerm("localEndpoint.serviceName", serviceName.toLowerCase(Locale.ROOT));
        SearchRequest request = SearchRequest.create(indices).filters(filters).addAggregation(Aggregation.terms(term, Integer.MAX_VALUE));
        return this.search.newCall(request, BodyConverters.KEYS);
    }

    public Call<List<DependencyLink>> getDependencies(long endTs, long lookback) {
        if (endTs <= 0L) {
            throw new IllegalArgumentException("endTs <= 0");
        }
        if (lookback <= 0L) {
            throw new IllegalArgumentException("lookback <= 0");
        }
        long beginMillis = Math.max(endTs - lookback, 1456790400000L);
        List<String> indices = this.indexNameFormatter.formatTypeAndRange("dependency", beginMillis, endTs);
        if (indices.isEmpty()) {
            return Call.emptyList();
        }
        return this.search.newCall(SearchRequest.create(indices), BodyConverters.DEPENDENCY_LINKS);
    }

    static final class GetSpansByTraceId
    implements Call.FlatMapper<List<String>, List<Span>> {
        final SearchCallFactory search;
        final List<String> indices;

        GetSpansByTraceId(SearchCallFactory search, List<String> indices) {
            this.search = search;
            this.indices = indices;
        }

        public Call<List<Span>> map(List<String> input) {
            if (input.isEmpty()) {
                return Call.emptyList();
            }
            SearchRequest getTraces = SearchRequest.create(this.indices).terms("traceId", input);
            return this.search.newCall(getTraces, BodyConverters.SPANS);
        }

        public String toString() {
            return "GetSpansByTraceId{indices=" + this.indices + "}";
        }
    }
}

