/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal;

import java.time.format.DateTimeFormatter;
import zipkin2.elasticsearch.internal.IndexNameFormatter;

final class AutoValue_IndexNameFormatter
extends IndexNameFormatter {
    private final String index;
    private final char dateSeparator;
    private final DateTimeFormatter dateFormat;

    private AutoValue_IndexNameFormatter(String index, char dateSeparator, DateTimeFormatter dateFormat) {
        this.index = index;
        this.dateSeparator = dateSeparator;
        this.dateFormat = dateFormat;
    }

    @Override
    public String index() {
        return this.index;
    }

    @Override
    char dateSeparator() {
        return this.dateSeparator;
    }

    @Override
    DateTimeFormatter dateFormat() {
        return this.dateFormat;
    }

    public String toString() {
        return "IndexNameFormatter{index=" + this.index + ", dateSeparator=" + this.dateSeparator + ", dateFormat=" + this.dateFormat + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IndexNameFormatter) {
            IndexNameFormatter that = (IndexNameFormatter)o;
            return this.index.equals(that.index()) && this.dateSeparator == that.dateSeparator() && this.dateFormat.equals(that.dateFormat());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.index.hashCode();
        h$ *= 1000003;
        h$ ^= this.dateSeparator;
        h$ *= 1000003;
        return h$ ^= this.dateFormat.hashCode();
    }

    @Override
    public IndexNameFormatter.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends IndexNameFormatter.Builder {
        private String index;
        private Character dateSeparator;
        private DateTimeFormatter dateFormat;

        Builder() {
        }

        private Builder(IndexNameFormatter source) {
            this.index = source.index();
            this.dateSeparator = Character.valueOf(source.dateSeparator());
            this.dateFormat = source.dateFormat();
        }

        @Override
        public IndexNameFormatter.Builder index(String index) {
            if (index == null) {
                throw new NullPointerException("Null index");
            }
            this.index = index;
            return this;
        }

        @Override
        public IndexNameFormatter.Builder dateSeparator(char dateSeparator) {
            this.dateSeparator = Character.valueOf(dateSeparator);
            return this;
        }

        @Override
        char dateSeparator() {
            if (this.dateSeparator == null) {
                throw new IllegalStateException("Property \"dateSeparator\" has not been set");
            }
            return this.dateSeparator.charValue();
        }

        @Override
        IndexNameFormatter.Builder dateFormat(DateTimeFormatter dateFormat) {
            if (dateFormat == null) {
                throw new NullPointerException("Null dateFormat");
            }
            this.dateFormat = dateFormat;
            return this;
        }

        @Override
        IndexNameFormatter autoBuild() {
            String missing = "";
            if (this.index == null) {
                missing = missing + " index";
            }
            if (this.dateSeparator == null) {
                missing = missing + " dateSeparator";
            }
            if (this.dateFormat == null) {
                missing = missing + " dateFormat";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_IndexNameFormatter(this.index, this.dateSeparator.charValue(), this.dateFormat);
        }
    }
}

