/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpRequestWriter;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import io.netty.util.concurrent.EventExecutor;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.elasticsearch.internal.JsonSerializers;

public final class HttpCall<V>
extends Call.Base<V> {
    public final RequestSupplier request;
    final BodyConverter<V> bodyConverter;
    final String name;
    final WebClient httpClient;
    volatile CompletableFuture<AggregatedHttpResponse> responseFuture;

    HttpCall(WebClient httpClient, RequestSupplier request, BodyConverter<V> bodyConverter, String name) {
        this.httpClient = httpClient;
        this.name = name;
        this.request = request;
        this.bodyConverter = bodyConverter;
    }

    protected V doExecute() throws IOException {
        AggregatedHttpResponse response;
        for (EventExecutor eventLoop : this.httpClient.options().factory().eventLoopGroup()) {
            if (!eventLoop.inEventLoop()) continue;
            throw new RuntimeException("Attempting to make a blocking request from an event loop. Either use doEnqueue() or run this in a separate thread.");
        }
        try {
            response = this.sendRequest().join();
        }
        catch (CompletionException e) {
            HttpCall.propagateIfFatal((Throwable)e);
            Exceptions.throwUnsafely((Throwable)e.getCause());
            return null;
        }
        return this.parseResponse(response, this.bodyConverter);
    }

    protected void doEnqueue(Callback<V> callback) {
        this.sendRequest().handle((response, t) -> {
            if (t != null) {
                callback.onError(t);
            } else {
                try {
                    V value = this.parseResponse((AggregatedHttpResponse)response, this.bodyConverter);
                    callback.onSuccess(value);
                }
                catch (Throwable t1) {
                    HttpCall.propagateIfFatal((Throwable)t1);
                    callback.onError(t1);
                }
            }
            return null;
        });
    }

    protected void doCancel() {
        CompletableFuture<AggregatedHttpResponse> responseFuture = this.responseFuture;
        if (responseFuture != null) {
            responseFuture.cancel(false);
        }
    }

    public HttpCall<V> clone() {
        return new HttpCall<V>(this.httpClient, this.request, this.bodyConverter, this.name);
    }

    public String toString() {
        return "HttpCall(" + this.request + ")";
    }

    CompletableFuture<AggregatedHttpResponse> sendRequest() {
        HttpResponse response;
        try (SafeCloseable ignored = Clients.withContextCustomizer(ctx -> ctx.logBuilder().name(this.name));){
            HttpRequestWriter httpRequest = HttpRequest.streaming((RequestHeaders)this.request.headers());
            response = this.httpClient.execute((HttpRequest)httpRequest);
            this.request.writeBody(arg_0 -> ((HttpRequestWriter)httpRequest).tryWrite(arg_0));
            httpRequest.close();
        }
        CompletionStage responseFuture = (CompletableFuture)RequestContext.mapCurrent(ctx -> response.aggregateWithPooledObjects((EventExecutor)ctx.eventLoop(), ctx.alloc()), () -> ((HttpResponse)response).aggregate());
        this.responseFuture = responseFuture = responseFuture.exceptionally(t -> {
            if (t instanceof UnprocessedRequestException) {
                Throwable cause = t.getCause();
                Exceptions.clearTrace((Throwable)cause);
                String message = cause.getMessage();
                if (message == null) {
                    message = cause.getClass().getSimpleName();
                }
                throw new RejectedExecutionException(message, cause);
            }
            Exceptions.throwUnsafely((Throwable)t);
            return null;
        });
        return responseFuture;
    }

    /*
     * Exception decompiling
     */
    V parseResponse(AggregatedHttpResponse response, BodyConverter<V> bodyConverter) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private /* synthetic */ Object lambda$parseResponse$4(JsonParser parser, Supplier contentString) throws IOException {
        String message = null;
        try {
            JsonNode root = (JsonNode)JsonSerializers.OBJECT_MAPPER.readTree(parser);
            message = root.findPath("reason").textValue();
            if (message == null) {
                message = root.at("/Message").textValue();
            }
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
        throw new RuntimeException(message != null ? message : "response for " + this.request.headers().path() + " failed: " + (String)contentString.get());
    }

    public static interface RequestSupplier {
        public RequestHeaders headers();

        public void writeBody(RequestStream var1);
    }

    public static interface BodyConverter<V> {
        public V convert(JsonParser var1, Supplier<String> var2) throws IOException;
    }

    public static interface RequestStream {
        public boolean tryWrite(HttpData var1);
    }

    public static class Factory {
        final WebClient httpClient;

        public Factory(WebClient httpClient) {
            this.httpClient = httpClient;
        }

        public <V> HttpCall<V> newCall(AggregatedHttpRequest request, BodyConverter<V> bodyConverter, String name) {
            return new HttpCall<V>(this.httpClient, new AggregatedRequestSupplier(request), bodyConverter, name);
        }

        public <V> HttpCall<V> newCall(RequestSupplier request, BodyConverter<V> bodyConverter, String name) {
            return new HttpCall<V>(this.httpClient, request, bodyConverter, name);
        }
    }

    static class AggregatedRequestSupplier
    implements RequestSupplier {
        final AggregatedHttpRequest request;

        AggregatedRequestSupplier(AggregatedHttpRequest request) {
            try (HttpData content = request.content();){
                this.request = !content.isPooled() ? request : AggregatedHttpRequest.of((RequestHeaders)request.headers(), (HttpData)HttpData.wrap((byte[])content.array()), (HttpHeaders)request.trailers());
            }
        }

        @Override
        public RequestHeaders headers() {
            return this.request.headers();
        }

        @Override
        public void writeBody(RequestStream requestStream) {
            requestStream.tryWrite(this.request.content());
        }
    }
}

