/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch;

import zipkin2.elasticsearch.ElasticsearchVersion;
import zipkin2.elasticsearch.IndexTemplates;

final class VersionSpecificTemplates {
    static final int SHORT_STRING_LENGTH = 256;
    static final String TYPE_AUTOCOMPLETE = "autocomplete";
    static final String TYPE_SPAN = "span";
    static final String TYPE_DEPENDENCY = "dependency";
    static final String KEYWORD = "{ \"type\": \"keyword\", \"norms\": false }";
    final String indexPrefix;
    final int indexReplicas;
    final int indexShards;
    final boolean searchEnabled;
    final boolean strictTraceId;
    final Integer templatePriority;

    VersionSpecificTemplates(String indexPrefix, int indexReplicas, int indexShards, boolean searchEnabled, boolean strictTraceId, Integer templatePriority) {
        this.indexPrefix = indexPrefix;
        this.indexReplicas = indexReplicas;
        this.indexShards = indexShards;
        this.searchEnabled = searchEnabled;
        this.strictTraceId = strictTraceId;
        this.templatePriority = templatePriority;
    }

    String indexPattern(String type, ElasticsearchVersion version) {
        return '\"' + (version.compareTo(ElasticsearchVersion.V6_0) < 0 ? "template" : "index_patterns") + "\": \"" + this.indexPrefix + VersionSpecificTemplates.indexTypeDelimiter(version) + type + "-*\"";
    }

    String indexProperties(ElasticsearchVersion version) {
        String result = "    \"index.number_of_shards\": " + this.indexShards + ",\n    \"index.number_of_replicas\": " + this.indexReplicas + ",\n    \"index.requests.cache.enable\": true";
        return result + "\n";
    }

    String indexTemplate(ElasticsearchVersion version) {
        if (this.useComposableTemplate(version)) {
            return "\"template\": {\n";
        }
        return "";
    }

    String indexTemplateClosing(ElasticsearchVersion version) {
        if (this.useComposableTemplate(version)) {
            return "},\n";
        }
        return "";
    }

    String templatePriority(ElasticsearchVersion version) {
        if (this.useComposableTemplate(version)) {
            return "\"priority\": " + this.templatePriority + "\n";
        }
        return "";
    }

    String beginTemplate(String type, ElasticsearchVersion version) {
        return "{\n  " + this.indexPattern(type, version) + ",\n" + this.indexTemplate(version) + "  \"settings\": {\n" + this.indexProperties(version);
    }

    String endTemplate(ElasticsearchVersion version) {
        return this.indexTemplateClosing(version) + this.templatePriority(version) + "}";
    }

    String spanIndexTemplate(ElasticsearchVersion version) {
        String result = this.beginTemplate(TYPE_SPAN, version);
        String traceIdMapping = KEYWORD;
        if (!this.strictTraceId) {
            traceIdMapping = "{ \"type\": \"text\", \"fielddata\": \"true\", \"analyzer\": \"traceId_analyzer\" }";
            result = result + ",\n    \"analysis\": {\n      \"analyzer\": {\n        \"traceId_analyzer\": {\n          \"type\": \"custom\",\n          \"tokenizer\": \"keyword\",\n          \"filter\": \"traceId_filter\"\n        }\n      },\n      \"filter\": {\n        \"traceId_filter\": {\n          \"type\": \"pattern_capture\",\n          \"patterns\": [\"([0-9a-f]{1,16})$\"],\n          \"preserve_original\": true\n        }\n      }\n    }\n";
        }
        result = result + "  },\n";
        if (this.searchEnabled) {
            return result + "  \"mappings\": {\n" + VersionSpecificTemplates.maybeWrap(TYPE_SPAN, version, "    \"_source\": {\"excludes\": [\"_q\"] },\n    \"dynamic_templates\": [\n      {\n        \"strings\": {\n          \"mapping\": {\n            \"type\": \"keyword\",\"norms\": false, \"ignore_above\": 256\n          },\n          \"match_mapping_type\": \"string\",\n          \"match\": \"*\"\n        }\n      }\n    ],\n    \"properties\": {\n      \"traceId\": " + traceIdMapping + ",\n      \"name\": " + KEYWORD + ",\n      \"localEndpoint\": {\n        \"type\": \"object\",\n        \"dynamic\": false,\n        \"properties\": { \"serviceName\": " + KEYWORD + " }\n      },\n      \"remoteEndpoint\": {\n        \"type\": \"object\",\n        \"dynamic\": false,\n        \"properties\": { \"serviceName\": " + KEYWORD + " }\n      },\n      \"timestamp_millis\": {\n        \"type\":   \"date\",\n        \"format\": \"epoch_millis\"\n      },\n      \"duration\": { \"type\": \"long\" },\n      \"annotations\": { \"enabled\": false },\n      \"tags\": { \"enabled\": false },\n      \"_q\": " + KEYWORD + "\n    }\n") + "  }\n" + this.endTemplate(version);
        }
        return result + "  \"mappings\": {\n" + VersionSpecificTemplates.maybeWrap(TYPE_SPAN, version, "    \"properties\": {\n      \"traceId\": " + traceIdMapping + ",\n      \"annotations\": { \"enabled\": false },\n      \"tags\": { \"enabled\": false }\n    }\n") + "  }\n" + this.endTemplate(version);
    }

    String dependencyTemplate(ElasticsearchVersion version) {
        return this.beginTemplate(TYPE_DEPENDENCY, version) + "  },\n  \"mappings\": {\n" + VersionSpecificTemplates.maybeWrap(TYPE_DEPENDENCY, version, "    \"enabled\": false\n") + "  }\n" + this.endTemplate(version);
    }

    String autocompleteTemplate(ElasticsearchVersion version) {
        return this.beginTemplate(TYPE_AUTOCOMPLETE, version) + "  },\n  \"mappings\": {\n" + VersionSpecificTemplates.maybeWrap(TYPE_AUTOCOMPLETE, version, "    \"enabled\": true,\n    \"properties\": {\n      \"tagKey\": { \"type\": \"keyword\", \"norms\": false },\n      \"tagValue\": { \"type\": \"keyword\", \"norms\": false }\n    }\n") + "  }\n" + this.endTemplate(version);
    }

    IndexTemplates get(ElasticsearchVersion version) {
        if (version.compareTo(ElasticsearchVersion.V5_0) < 0 || version.compareTo(ElasticsearchVersion.V8_0) >= 0) {
            throw new IllegalArgumentException("Elasticsearch versions 5-7.x are supported, was: " + version);
        }
        return IndexTemplates.newBuilder().version(version).indexTypeDelimiter(VersionSpecificTemplates.indexTypeDelimiter(version)).span(this.spanIndexTemplate(version)).dependency(this.dependencyTemplate(version)).autocomplete(this.autocompleteTemplate(version)).build();
    }

    boolean useComposableTemplate(ElasticsearchVersion version) {
        return version.compareTo(ElasticsearchVersion.V7_8) >= 0 && this.templatePriority != null;
    }

    static char indexTypeDelimiter(ElasticsearchVersion version) {
        return version.compareTo(ElasticsearchVersion.V7_0) < 0 ? (char)':' : '-';
    }

    static String maybeWrap(String type, ElasticsearchVersion version, String json) {
        if (version.compareTo(ElasticsearchVersion.V7_0) >= 0) {
            return json;
        }
        return "    \"" + type + "\": {\n  " + json.replace("\n", "\n  ") + "  }\n";
    }
}

