/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import zipkin2.internal.Nullable;

public final class JsonReaders {
    @Nullable
    public static JsonParser enterPath(JsonParser parser, String path1, String path2) throws IOException {
        return JsonReaders.enterPath(parser, path1) != null ? JsonReaders.enterPath(parser, path2) : null;
    }

    @Nullable
    public static JsonParser enterPath(JsonParser parser, String path) throws IOException {
        JsonToken value;
        if (!JsonReaders.checkStartObject(parser, false)) {
            return null;
        }
        while ((value = parser.nextValue()) != JsonToken.END_OBJECT) {
            if (value == null) {
                return null;
            }
            if (parser.getCurrentName().equalsIgnoreCase(path) && value != JsonToken.VALUE_NULL) {
                return parser;
            }
            parser.skipChildren();
        }
        return null;
    }

    public static List<String> collectValuesNamed(JsonParser parser, String name) throws IOException {
        JsonReaders.checkStartObject(parser, true);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        JsonReaders.visitObject(parser, name, result);
        return new ArrayList<String>(result);
    }

    static void visitObject(JsonParser parser, String name, Set<String> result) throws IOException {
        JsonToken value;
        JsonReaders.checkStartObject(parser, true);
        while ((value = parser.nextValue()) != JsonToken.END_OBJECT) {
            if (value == null) {
                return;
            }
            if (parser.getCurrentName().equals(name)) {
                result.add(parser.getText());
                continue;
            }
            JsonReaders.visitNextOrSkip(parser, name, result);
        }
    }

    static void visitNextOrSkip(JsonParser parser, String name, Set<String> result) throws IOException {
        switch (parser.currentToken()) {
            case START_ARRAY: {
                JsonToken token;
                while ((token = parser.nextToken()) != JsonToken.END_ARRAY) {
                    if (token == null) {
                        return;
                    }
                    JsonReaders.visitObject(parser, name, result);
                }
                break;
            }
            case START_OBJECT: {
                JsonReaders.visitObject(parser, name, result);
                break;
            }
        }
    }

    static boolean checkStartObject(JsonParser parser, boolean shouldThrow) throws IOException {
        try {
            JsonToken currentToken = parser.currentToken();
            if (currentToken == null) {
                currentToken = parser.nextToken();
            }
            if (currentToken == JsonToken.START_OBJECT) {
                return true;
            }
            if (shouldThrow) {
                throw new IllegalArgumentException("Expected start object, was " + currentToken);
            }
            return false;
        }
        catch (Throwable e) {
            if (shouldThrow) {
                throw e;
            }
            return false;
        }
    }

    JsonReaders() {
    }
}

